#include <butil/StrUtils/Encoding.h>
#include <string.h>
#include <butil/butil.h>

/*

$Log$
Revision 1.2  2005/03/11 10:56:39  virtan
Quoted-printable accepts a-f in char codes now.
Html2Lite is a function for sanitizing text/html now.

Revision 1.1.1.1  2005/03/10 11:06:40  virtan
Initial importing


*/

void Encoding::decode(const std::string& type, std::string &source, bool mergeParts)
{
    if(!strcasecmp(type.c_str(),"quoted-printable")) {
        source=decode_qp(source);
    } else if(!strcasecmp(type.c_str(),"base64")) {
        source = mergeParts
            ? decode_base64_mergeparts(source)
            : decode_base64(source);
    }
}

void Encoding::encode(const std::string& type, std::string &source, bool splitLines)
{
    if(!strcasecmp(type.c_str(),"quoted-printable")) {
        source=encode_qp(source);
    } else if(!strcasecmp(type.c_str(),"base64")) {
        source = splitLines
            ? encode_base64_splitline(source)
            : encode_base64(source);
    }
}
