#include <butil/StrUtils/StrUtils.h>

#include <queue>
#include <sstream>
#include <ctype.h>
#include <algorithm>

using std::string;

std::string
TStrUtils::
trim ( const std::string& str,
    const std::string& what )
{
    using std::string;

    const string::size_type begin = str.find_first_not_of( what.c_str( ) );
    const string::size_type end = str.find_last_not_of( what.c_str( ) );

    if ( string::npos == begin || string::npos == end )
    {
        return string( );
    }
    return str.substr( begin, end - begin + 1 );
}

std::string
TStrUtils::
stringToLower ( const std::string& str )
{
    std::string result;
    const size_t size = str.size( );
    result.reserve( size );
    for ( size_t i = 0; i < size; ++i )
    {
        result += char(::tolower( str[i] ));
    }
    return result;
}

void TStrUtils::replaceBadSymbols ( std::string& str, const std::string::value_type replaceBy )
{
    for ( string::size_type i = 0; i < str.size( ); ++i )
    {
        std::string::value_type & ch = str[ i ];
        if ( static_cast < unsigned char > ( ch ) < 32 &&
            '\n' != ch && '\r' != ch && '\t' != ch )
        {
            ch = replaceBy;
        }
    }
}

std::string TStrUtils::removeBadSymbols ( const std::string & str )
{
    string res = "";
    for ( string::size_type i = 0; i < str.length( ); ++i )
    {
        const std::string::value_type ch =  str[i];
        if ( static_cast < unsigned char > ( ch ) >= 32
            || '\n' == ch || '\r' == ch || '\t' == ch )
        {
            res += ch;
        }
    }
    return res;
}

bool TStrUtils::isControlChar(char c) {
    return (static_cast<unsigned char>(c)) < 32;
}

std::string TStrUtils::removeAllBadSymbols(const std::string& str_) {
    std::string str = str_;
    std::string::iterator goodSymbolsEndIterator = std::remove_if(str.begin(), str.end(), isControlChar);
    str.erase(goodSymbolsEndIterator, str.end());
    return str;
}

std::string TStrUtils::foldLine(const std::string& line) {
    static const size_t MAX_LINE_LENGTH = 78;

    if (line.length() <= MAX_LINE_LENGTH) {
        return line;
    }

    std::string result = line.substr(0, MAX_LINE_LENGTH);
    size_t pos = MAX_LINE_LENGTH;
    while (pos < line.length()) {
        result += "\r\n\t" + line.substr(pos, MAX_LINE_LENGTH - 1);
        pos += MAX_LINE_LENGTH - 1;
    }
    return result;
}

bool TStrUtils::isNum(const std::string& s) {
    return !s.empty() && std::find_if(s.begin(), s.end(), std::not_fn(std::ptr_fun(isdigit))) == s.end();
}

std::string TStrUtils::unescape(const std::string& str) {
    std::string res;
    bool escaped = false;
    for (size_t i = 0; i < str.size(); ++i) {
        char c = str[i];
        if (!escaped && c == '\\') {
            escaped = true;
        } else {
            res.push_back(c);
            escaped = false;
        }
    }
    return res;
}

std::string TStrUtils::removeSurroundQuotes(const std::string& str) {
    return (!str.empty() && *str.begin() == '"' && *str.rbegin() == '"')
        ? str.substr(1, str.size() - 2)
        : str;
}

