/*
 * pystrutils.cpp
 *
 *  Created on: Aug 12, 2008
 *      Author: master
 */

#include <butil/StrUtils/pystrutils.h>
#include <butil/StrUtils/utf8.h>
#include <iostream>

using namespace pystrutils;

inline bool utf8s (char a)
{
    return (a & 0xc0) == 128;
}

template <typename In, typename Out>
double validateUtf8 ( In first, In last, Out out )
{
    const std::size_t len = std::distance(first,last);
    if (!len) {
        return 0.0;
    }
    size_t badCharCount = 0;
    while (first !=last) {
        if(is_valid_utf8_char(first,last)) {
            In next = next_utf8_char(first);
            out = std::copy(first, next, out);
            first = next;
        } else {
            *out++='?';
            ++first;
            ++badCharCount;
        }
    }
    return double(badCharCount)/double(len);
}

std::string pystrutils::get_validated_utf8( const std::string & src )
{
    std::string retval;
    retval.reserve(src.capacity());
    validateUtf8 ( src.begin(), src.end(), std::back_inserter(retval) );
    return retval;
}

pystrutils::string& operator*= (pystrutils::string &a, size_t N)
{
	pystrutils::string tmp;
	while (N--)
		tmp.append(a);
	a.swap(tmp);
	return a;
}

pystrutils::string operator* (const pystrutils::string &a, size_t N)
{
	pystrutils::string tmp = a;
	return tmp *= N;
}

pystrutils::string operator* (size_t N, const pystrutils::string &a)
{
	return a*N;
}

std::ostream& operator<< (std::ostream& bugaga, std::vector<pystrutils::string> result)
{
	bugaga << "[\n";
	bool notfirst = false;
	for (size_t i = 0; i < result.size(); i++)
	{
		if (notfirst)
		{
			bugaga << ",\n" << result[i];
		}
		else
		{
			bugaga << result[i];
			notfirst = true;
		}
	}
	bugaga << "\n]";
	return bugaga;
}
