#include <string>
#include <locale>
#include <butil/StrUtils/Iconv.h>


namespace utf {
    std::wstring to_wstring(const std::string& from)
    {
        Iconv cnv("UTF-8", "UCS-4LE");
        std::string tmp = cnv.recode(from);
        return std::wstring(reinterpret_cast<const wchar_t*>(tmp.data()), tmp.size() / 4);
    }

    std::string to_string(const std::wstring& from)
    {
        Iconv cnv("UCS-4LE", "UTF-8");
        std::string tmp(reinterpret_cast<const char*>(from.data()), from.size() * 4);
        return cnv.recode(tmp);
    }

    void to_lower(std::string& src)
    {
        std::locale loc("ru_RU.UTF-8");
        std::wstring buf = to_wstring(src);
        for(size_t i = 0; i < buf.size(); ++i)
            buf[i] = std::tolower(buf[i], loc);
        src = to_string(buf);
    }

    bool cut(std::string& src, std::string::size_type length)
    {
        std::wstring buf = to_wstring(src);
        if(length < buf.size()) {
            buf.erase(length, buf.size());
            src = to_string(buf);
            return true;
        }
        return false;
    }
}
