/* -*- C++ -*- */

// $Log$
// Revision 1.5  2005/11/15 12:18:43  alg
// make unsplitted encode_base64
//
// Revision 1.4  2005/10/11 09:01:28  alg
// fix mem calc from output base64
//
// Revision 1.3  2005/10/11 08:23:44  alg
// make encode_base64 split by lines and clear crln from cont-type in libcgi++
//
// Revision 1.2  2005/10/06 13:51:53  alg
// Partial content (bacek)
//
// Revision 1.1.1.1  2005/05/27 14:44:55  virtan
// Second version. With autotools.
//
// Revision 1.12  2004/09/06 08:27:48  bacek
// Split continues
//
// Revision 1.11  2004/05/28 12:56:21  alg
//  uptodate
//
// Revision 1.10  2003/03/07 13:30:51  alg
// b64 fix
//
// Revision 1.9  2003/02/27 08:55:56  alg
// All bugs fixed
//
// Revision 1.8  2002/10/01 12:40:03  alg
// Use baida md5 fset
//
// Revision 1.7  2002/05/24 14:48:15  alg
// Namespacing
//
// Revision 1.6  2002/05/23 15:21:20  alg
// thr pool suspending
//
// Revision 1.5  2002/05/19 07:13:26  alg
// Wrk
//
// Revision 1.4  2002/04/05 17:17:30  alg
// Wrk
//
// Revision 1.3  2002/04/04 10:45:28  alg
// SMP string fight
//
// Revision 1.2  2002/02/21 20:05:08  alg
// Wrk
//
// Revision 1.1  2001/12/04 09:26:31  alg
// Wrk
//
// Revision 1.1.1.1  2000/07/25 15:00:00  alg
// First import
//
// Revision 1.1  1995/09/20  18:25:14  alexey
// Initial revision
//

/* MD5C.C - RSA Data Security, Inc., MD5 message-digest algorithm
 */

/* Copyright (C) 1991-2, RSA Data Security, Inc. Created 1991. All
rights reserved.

License to copy and use this software is granted provided that it
is identified as the "RSA Data Security, Inc. MD5 Message-Digest
Algorithm" in all material mentioning or referencing this software
or this function.

License is also granted to make and use derivative works provided
that such works are identified as "derived from the RSA Data
Security, Inc. MD5 Message-Digest Algorithm" in all material
mentioning or referencing the derived work.

RSA Data Security, Inc. makes no representations concerning either
the merchantability of this software or the suitability of this
software for any particular purpose. It is provided "as is"
without express or implied warranty of any kind.

These notices must be retained in any copies of any part of this
documentation and/or software.
 */

#include <butil/butil.h>


const int BASE64_CHUNK_LENGTH = 4;
const int INPUT_CHUNK_LENGTH = 3;
const int JUST_IN_CASE_SPACE = 128;
const int CRLF_LENGTH = 2;

/* How many bytes it will take to store LEN bytes in base64.  */
inline int base64Length(int srcLength, int maxLineLength) {
    int dstLength = BASE64_CHUNK_LENGTH *
            ((srcLength + INPUT_CHUNK_LENGTH - 1) / INPUT_CHUNK_LENGTH) + JUST_IN_CASE_SPACE;
    if (maxLineLength > 0) {
        dstLength += CRLF_LENGTH * dstLength / maxLineLength;
    }
    return dstLength;
}

#define MAX_LINE 76

/* Encode the std::string S of length LENGTH to base64 format and place it
   to STORE.  STORE will be 0-terminated, and must point to a writable
   buffer of at least 1+BASE64_LENGTH(length) bytes.  */
static void
i_base64_encode (const char *s, char *store, int length, int max_line)
{
  /* Conversion table.
  char safe[]="\0\0\0\0";
  */
  static char tbl[64] = {
    'A','B','C','D','E','F','G','H',
    'I','J','K','L','M','N','O','P',
    'Q','R','S','T','U','V','W','X',
    'Y','Z','a','b','c','d','e','f',
    'g','h','i','j','k','l','m','n',
    'o','p','q','r','s','t','u','v',
    'w','x','y','z','0','1','2','3',
    '4','5','6','7','8','9','+','/'
  };
  int i;
  unsigned char *p = reinterpret_cast<unsigned char *>(store);

  /* Transform the 3x8 bits to 4x6 bits, as required by base64.  */
  int line_len=0;
  for (i = 0; (i + INPUT_CHUNK_LENGTH) <= length; i += INPUT_CHUNK_LENGTH)
    {
      *p++ = tbl[(s[0] & 0xFC) >> 2];
      *p++ = tbl[((s[0] & 3) << 4) + ((s[1] & 0xF0) >> 4)];
      *p++ = tbl[((s[1] & 0xf) << 2) + ((s[2] & 0xC0) >> 6)];
      *p++ = tbl[s[2] & 0x3f];
      s += INPUT_CHUNK_LENGTH;
      line_len += BASE64_CHUNK_LENGTH;
      if ((max_line>0) && (line_len > max_line - BASE64_CHUNK_LENGTH)) {
          *p++='\r';
          *p++='\n';
          line_len=0;
      }
    }
  if (i + 1 == length)
  {
    *p++ = tbl[((s[0]) & 0xFC) >> 2];
    *p++ = tbl[((s[0] & 3) << 4)];
    *p++ = '=';
    *p++ = '=';
  }
  else if (i + 2 == length)
  {
      *p++ = tbl[(s[0] & 0xFC) >> 2];
      *p++ = tbl[((s[0] & 3) << 4) + ((s[1] & 0xF0) >> 4)];
      *p++ = tbl[((s[1] & 0xf) << 2)];
      *p++ = '=';
  }
  *p = '\0';
}


std::string
encode_base64(const std::string& src)
{
  int len1 = int(src.length());
  int len2 = base64Length(len1, 0);
  char* t2 = new char[(1 + len2)];
  i_base64_encode (src.data(), t2, len1,0);
  std::string r(t2);
  delete [] t2;
  return r;
}

std::string
encode_base64_splitline(const std::string& src)
{
  int len1 = int(src.length());
  int len2 = base64Length(len1, MAX_LINE);
  char* t2 = new char[(1 + len2)];
  i_base64_encode (src.data(), t2, len1,MAX_LINE);
  std::string r(t2);
  delete [] t2;
  return r;
}


static char base64idx[128] = {
    '\377','\377','\377','\377','\377','\377','\377','\377',
    '\377','\377','\377','\377','\377','\377','\377','\377',
    '\377','\377','\377','\377','\377','\377','\377','\377',
    '\377','\377','\377','\377','\377','\377','\377','\377',
    '\377','\377','\377','\377','\377','\377','\377','\377',
    '\377','\377','\377',    62,'\377','\377','\377',    63,
        52,    53,    54,    55,    56,    57,    58,    59,
        60,    61,'\377','\377','\377','\377','\377','\377',
    '\377',     0,     1,     2,     3,     4,     5,     6,
         7,     8,     9,    10,    11,    12,    13,    14,
        15,    16,    17,    18,    19,    20,    21,    22,
        23,    24,    25,'\377','\377','\377','\377','\377',
    '\377',    26,    27,    28,    29,    30,    31,    32,
        33,    34,    35,    36,    37,    38,    39,    40,
        41,    42,    43,    44,    45,    46,    47,    48,
        49,    50,    51,'\377','\377','\377','\377','\377'
};

namespace {

inline int
isbase64(int a)
{
    return ('A' <= a && a <= 'Z')
        || ('a' <= a && a <= 'z')
        || ('0' <= a && a <= '9')
        || a == '+' || a == '/';
}

inline bool isBase64Empty(int a) {
    return (a == '=') || a == 0;
}

}

static int
i_base64_decode(const char* aIn, size_t aInLen, char* aOut,
    size_t aOutSize, size_t* aOutLen, size_t* aInCount)
{
    if (!aIn || !aOut || !aOutLen)
        return -1;
    size_t inLen = aInLen;
    char* out = aOut;
    size_t outSize = (inLen+3)/4*3;
    if (aOutSize < outSize)
        return -1;
    /* Get four input chars at a time and decode them. Ignore white space
     * chars (CR, LF, SP, HT). If '=' is encountered, terminate input. If
     * a char other than white space, base64 char, or '=' is encountered,
     * flag an input error, but otherwise ignore the char.
     */
    int isErr = 0;
    int isEndSeen = 0;
    int b1, b2, b3;
    int a1, a2, a3, a4;
    size_t inPos = 0;
    size_t outPos = 0;
    while (inPos < inLen) {
        a1 = a2 = a3 = a4 = 0;
        while (inPos < inLen) {
            a1 = aIn[inPos++] & 0xFF;

            if (isbase64(a1)) {
                break;
            }
            else if (a1 == '=') {
                isEndSeen = 1;
                break;
            }
            else if (a1 != '\r' && a1 != '\n' && a1 != ' ' && a1 != '\t') {
                isErr = 1;
            }
        }
        while (inPos < inLen) {
            a2 = aIn[inPos++] & 0xFF;
            if (isbase64(a2)) {
                break;
            }
            else if (a2 == '=') {
                isEndSeen = 1;
                break;
            }
            else if (a2 != '\r' && a2 != '\n' && a2 != ' ' && a2 != '\t') {
                isErr = 1;
            }
        }
        while (inPos < inLen) {
            a3 = aIn[inPos++] & 0xFF;
            if (isbase64(a3)) {
                break;
            }
            else if (a3 == '=') {
                isEndSeen = 1;
                break;
            }
            else if (a3 != '\r' && a3 != '\n' && a3 != ' ' && a3 != '\t') {
                isErr = 1;
            }
        }
        while (inPos < inLen) {
            a4 = aIn[inPos++] & 0xFF;
            if (isbase64(a4)) {
                break;
            }
            else if (a4 == '=') {
                isEndSeen = 1;
                break;
            }
            else if (a4 != '\r' && a4 != '\n' && a4 != ' ' && a4 != '\t') {
                isErr = 1;
            }
        }
        if (isbase64(a1) && isbase64(a2) && isbase64(a3) && isbase64(a4)) {
            a1 = base64idx[a1] & 0xFF;
            a2 = base64idx[a2] & 0xFF;
            a3 = base64idx[a3] & 0xFF;
            a4 = base64idx[a4] & 0xFF;
            b1 = ((a1 << 2) & 0xFC) | ((a2 >> 4) & 0x03);
            b2 = ((a2 << 4) & 0xF0) | ((a3 >> 2) & 0x0F);
            b3 = ((a3 << 6) & 0xC0) | ( a4       & 0x3F);
            out[outPos++] = char(b1);
            out[outPos++] = char(b2);
            out[outPos++] = char(b3);
        }
        else if (isbase64(a1) && isbase64(a2) && isbase64(a3) && isBase64Empty(a4)) {
            a1 = base64idx[a1] & 0xFF;
            a2 = base64idx[a2] & 0xFF;
            a3 = base64idx[a3] & 0xFF;
            b1 = ((a1 << 2) & 0xFC) | ((a2 >> 4) & 0x03);
            b2 = ((a2 << 4) & 0xF0) | ((a3 >> 2) & 0x0F);
            out[outPos++] = char(b1);
            out[outPos++] = char(b2);
            break;
        }
        else if (isbase64(a1) && isbase64(a2) && isBase64Empty(a3) && isBase64Empty(a4)) {
            a1 = base64idx[a1] & 0xFF;
            a2 = base64idx[a2] & 0xFF;
            b1 = ((a1 << 2) & 0xFC) | ((a2 >> 4) & 0x03);
            out[outPos++] = char(b1);
            break;
        }
        else {
            break;
        }
        if (isEndSeen) {
            break;
        }
    } /* end while loop */
    *aOutLen = outPos;
    if (aInCount) {
        *aInCount = inPos;
    }
    return (isErr) ? -1 : 0;
}

std::string
decode_base64(const std::string& src)
{
   // Set destination buffer size same as source buffer size
    size_t srcLen = src.length();
    const char* srcBuf = src.data();
    size_t destSize = srcLen*2;

    // Allocate destination buffer
    std::string destStr(destSize, 0);
    char* destBuf = const_cast<char*>(destStr.data());

    // Encode source to destination
    size_t destLen = 0;
    //int result =
    i_base64_decode(srcBuf, srcLen, destBuf, destSize, &destLen, nullptr);
    std::string aDestStr;
    aDestStr.assign(destStr, 0, destLen);
    return aDestStr;
}

std::string
decode_base64_mergeparts(const std::string& src)
{
    const size_t dstBufferSize = (src.size() + INPUT_CHUNK_LENGTH) / BASE64_CHUNK_LENGTH * INPUT_CHUNK_LENGTH;
    std::string dst(dstBufferSize, '\0');

    auto dstIt = dst.begin();

    for (auto srcIt = src.begin(); src.end() != srcIt; ) {
        size_t dstSize = 0;
        size_t srcProcessedCount = 0;
        i_base64_decode(&(*srcIt), std::distance(srcIt, src.end()), &(*dstIt),
                                                    std::distance(dstIt, dst.end()),
                                                    &dstSize, &srcProcessedCount);
        std::advance(srcIt, srcProcessedCount);
        std::advance(dstIt, dstSize);

        if (0 == srcProcessedCount) {
            break;
        }
    }

    dst.erase(dstIt, dst.end());
    dst.shrink_to_fit();
    return dst;
}

static char hextab[] = "0123456789ABCDEF";


std::string
encode_qp(const std::string& src)
{
  std::string r;
  std::string::size_type i=0;
  while(i<src.length()) {
    int ch = src[i++] & 0xFF;
    if ((62 <= ch && ch <= 126) || (33 <= ch && ch <= 60)) {
            r += char(ch);
    }
    /* Space */
    else if (ch == ' ') {
            /* Space at end of line or end of input must be encoded */
      if (i >= src.length()         /* End of input? */
                || src[i] == '\n') {  /* End of line? */
                r += '=';
                r += '2';
                r += '0';
      } else {

        r +=' ';
      }
    } else if (ch == '\n') {
      r += '\n';
    } else if (ch & 0x80        /* 8-bit char */
                 || !(ch & 0xE0)  /* control char */
                 || ch == 0x7F    /* DEL */
                 || ch == '=') {  /* special case */
            r += '=';
            r += hextab[(ch >> 4) & 0x0F];
            r += hextab[ch & 0x0F];
    }
  }
  return r;
}

static char hex2int(int c)
{
        if ( a_isdigit(c) )
        {
                return char(c - '0');
        }
        else if ( c >= 'A' && c <= 'F' )
        {
                return char(c - 'A' + 10);
        }
        else if ( c >= 'a' && c <= 'f' )
        {
            return char(c - 'a' + 10);
        }
        else
        {
                return -1;
        }
}

std::string
decode_qp(const std::string& str)
{
  std::string r;
  std::string::size_type i=0;
  while(i<str.length()) {
    if ( (i+2 < str.length()) && (str[i] == '=') &&
         ( a_isdigit(str[i+1]) || (str[i+1]<='F' && str[i+1]>='A') || (str[i+1]<='f' && str[i+1]>='a'))
         &&
         ( a_isdigit(str[i+2]) || (str[i+2]<='F' && str[i+2]>='A') || (str[i+2]<='f' && str[i+2]>='a'))
       )
      {
                r += char((hex2int(str[i+1]) << 4 )
                           + hex2int(str[i+2]));
                i += 3;
      }
    else if ((i+1 < str.length()) && (str[i] == '=') && str[i+1]=='\n')
      {
                i+=2;
      }
    else if ((i+2 < str.length()) && (str[i] == '=') && str[i+1]=='\r' && str[i+2]=='\n')
      {
                i+=3;
      }
    else if ( str[i] == 13 )
      {
                i++;
      }
    else if ( str[i] != 127 ) // According to RFC 2045 , 6.7 , note 4
      {
                r += str[i++];
      }
    else
      {
                ++i;
      }

  }
  return r;
}

#define MAX_DIG 40

#define hx(a,b) sitoa(a,b,MAX_DIG-1,16)
#define dc(a,b) sitoa(a,b,MAX_DIG-1,10)
#define uhx(a,b) sutoa(a,b,MAX_DIG-1,16)
#define udc(a,b) sutoa(a,b,MAX_DIG-1,10)

#define lhx(a,b) slitoa(a,b,MAX_DIG-1,16)
#define ldc(a,b) slitoa(a,b,MAX_DIG-1,10)
#define luhx(a,b) slutoa(a,b,MAX_DIG-1,16)
#define ludc(a,b) slutoa(a,b,MAX_DIG-1,10)



inline void
put_rep(char * &out,const char * str,const char *endp)
{
  while(*str && out < endp)
    *out++=*str++;
}



static const char hexchars[] = "0123456789ABCDEF";

std::string
encode_url(const std::string& src, bool escape_whitespace, const char* skip_chars)
{
       int x, y,len=int(src.length());
       std::string str;

        for (x = 0, y = 0; len--; x++, y++) {
                str += static_cast<unsigned char>(src[x]);
                if (a_isalnum(str[y])
                      || strchr(skip_chars, str[y]) != 0 ) {
        /* Allow only alphanumeric chars and '_', '-', '.'; escape the rest */
                    continue;
                }
                if (str[y] == ' ' && !escape_whitespace) {
                    str[y] = '+';
                } else {
                    str[y]= '%';
                    str  += hexchars[static_cast<unsigned char>(src[x]) >> 4]; ++y;
                    str  += hexchars[static_cast<unsigned char>(src[x]) & 0x0F]; ++y;
                }

        }
        return str;
}

std::string
decode_url(const std::string& src)
{
    std::string r("");
    for( std::string::size_type i=0;i<src.length();++i) {
        if (src[i]!='%') {
            r +=(src[i]=='+')?' ':src[i];
        } else if ((i+2 < src.length()) && a_isxdigit(src[i+1]) && a_isxdigit(src[i+2])) {
            char c = char(strtol(src.substr(i+1,2).c_str(),0,16));
            r+=c;
            i +=2;
        } else { // Bug in path?
            return r;
        }
    }
    return r;
}
