/* ====================================================================
 * Copyright (c) 1996-1999 The Apache Group.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software developed by the Apache Group
 *    for use in the Apache HTTP server project (http://www.apache.org/)."
 *
 * 4. The names "Apache Server" and "Apache Group" must not be used to
 *    endorse or promote products derived from this software without
 *    prior written permission. For written permission, please contact
 *    apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * 6. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by the Apache Group
 *    for use in the Apache HTTP server project (http://www.apache.org/)."
 *
 * THIS SOFTWARE IS PROVIDED BY THE APACHE GROUP ``AS IS'' AND ANY
 * EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE APACHE GROUP OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Group and was originally based
 * on public domain software written at the National Center for
 * Supercomputing Applications, University of Illinois, Urbana-Champaign.
 * For more information on the Apache Group and the Apache HTTP server
 * project, please see <http://www.apache.org/>.
 *
 */

/*
 * util_date.c: date parsing utility routines
 *     These routines are (hopefully) platform-independent.
 *
 * 27 Oct 1996  Roy Fielding
 *     Extracted (with many modifications) from mod_proxy.c and
 *     tested with over 50,000 randomly chosen valid date strings
 *     and several hundred variations of invalid date strings.
 *
 */


#include <time.h>
#include <sys/time.h>
#include <string>
#include <butil/datetime/util_date.h>
#include <ctype.h>
#include <string.h>

#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wconversion"
#pragma GCC diagnostic ignored "-Wold-style-cast"

/* days per month -- nonleap! */
const short __spm[12] =
  { 0,
    (31),
    (31+28),
    (31+28+31),
    (31+28+31+30),
    (31+28+31+30+31),
    (31+28+31+30+31+30),
    (31+28+31+30+31+30+31),
    (31+28+31+30+31+30+31+31),
    (31+28+31+30+31+30+31+31+30),
    (31+28+31+30+31+30+31+31+30+31),
    (31+28+31+30+31+30+31+31+30+31+30),
  };

/* seconds per day */
#define SPD 24*60*60




static int gmt_offset=0;
static char time_zone[]="MSK";

class init_tm_var {
public:
  init_tm_var(void)
  {
    time_t tt=time(0);
    struct tm* tms=localtime(&tt);
    gmt_offset=tms->tm_gmtoff;
    if (tms->tm_zone)
      strcpy(time_zone,tms->tm_zone);
  }
};

init_tm_var set_tz_gmtoff;

int
gmt_off(void)
{
  return  gmt_offset;
}

const char*
tmzone(void)
{
  return &time_zone[0];
}



struct tm *
diet_gmtime_r(const time_t *timep, struct tm *r)
{
  time_t i;
  time_t work=*timep%(SPD);
  r->tm_sec=work%60; work/=60;
  r->tm_min=work%60; r->tm_hour=work/60;
  work=*timep/(SPD);
  r->tm_wday=(4+work)%7;
  for (i=1970; ; ++i) {
    time_t k=diet_isleap(i)?366:365;
    if (work>=k)
      work-=k;
    else
      break;
  }
  r->tm_year=i-1900;
  r->tm_yday=work;

  r->tm_mday=1;
  if (diet_isleap(i) && (work>58)) {
    if (work==59) r->tm_mday=2; /* 29.2. */
    work-=1;
  }

  for (i=11; i && (__spm[i]>work); --i) ;
  r->tm_mon=i;
  r->tm_mday+=work-__spm[i];
  r->tm_zone=0;
  return r;
}

struct tm *
diet_localtime_r(const time_t *t, struct tm *r)
{

  // Should be rewriten!
  time_t tmp=*t+gmt_off();
  return diet_gmtime_r(&tmp,r);
}


static const char   sweekdays [7] [4] = {
    "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"
};
static const char   weekdays [7] [10] = {
    "Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
static const char   smonths [12] [4] = {
    "Jan", "Feb", "Mar", "Apr", "May", "Jun",
    "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"
};
static const char*  months [12] = {
    "January", "February", "March", "April", smonths[5-1], "June",
    "July", "August", "September", "October", "November", "December"
};
static const char   ampm [4] [3] = {
    "am", "pm",
    "AM", "PM"
};

static int  i2a ( char* dest,unsigned int x )
{
    int  div = 10;
    *dest++ = x/div + '0';
    *dest++ = x%div + '0';
    *dest++ = '\0';
    return 2;
}



size_t
diet_strftime ( char* dst, size_t max, const char* format, const struct tm* tm )
{
    char*         p = dst;
    const char*   src;
    unsigned int  no;
    char          buf [6];
    int           diff;


    for ( ; *format != '\0'; format++ ) {
        if (*format == '%') {
            if (*++format == '%') {
                *p++ = '%';
            }
            else
again:
            switch (*format) {
//          case '%': *p++ = '%';                                break;
        // reduce size of jump table
            case 'n': *p++ = '\n';                               break;
            case 't': *p++ = '\t';                               break;
            case 'O': case 'E': ++format; goto again;
            case 'c': src = "%b %a %d %k:%M:%S %Z %Y";           goto _strf;
            case 'r': src = "%I:%M:%S %p";                       goto _strf;
            case 'R': src = "%H:%M";                             goto _strf;
            case 'x': src = "%b %a %d";                          goto _strf;
            case 'X': src = "%k:%M:%S";                          goto _strf;
            case 'D': src = "%m/%d/%y";                          goto _strf;
            case 'T': src = "%H:%M:%S";
               _strf: p  += diet_strftime (p, (size_t)(dst+max-p), src, tm);
 break;
            case 'a': src = sweekdays [tm->tm_wday];             goto _str;
            case 'A': src = weekdays  [tm->tm_wday];             goto _str;
            case 'h':
            case 'b': src = smonths   [tm->tm_mon];              goto _str;
            case 'B': src = months    [tm->tm_mon];              goto _str;
            case 'p': src = ampm [tm->tm_hour > 12 ? 3 : 2]; goto _str;
            case 'P': src = ampm [tm->tm_hour > 12 ? 1 : 0]; goto _str;
            case 'C': no  = tm->tm_year/100 + 19;                goto _no;
            case 'd': no  = tm->tm_mday;                         goto _no;
            case 'e': no  = tm->tm_mday;                         goto _nos;
            case 'H': no  = tm->tm_hour;                         goto _no;
            case 'I': no  = tm->tm_hour % 12;                    goto _no;
            case 'j': no  = tm->tm_yday;                         goto _no;
            case 'k': no  = tm->tm_hour;                         goto _nos;
            case 'l': no  = tm->tm_hour % 12;                    goto _nos;
            case 'm': no  = tm->tm_mon + 1;                      goto _no;
            case 'M': no  = tm->tm_min;                          goto _no;
            case 'S': no  = tm->tm_sec;                          goto _no;
            case 'u': no  = tm->tm_wday ? tm->tm_wday : 7;       goto _no;
            case 'w': no  = tm->tm_wday;                         goto _no;
            case 'U': no  = (tm->tm_yday - tm->tm_wday + 7) / 7; goto _no;
            case 'W': no  = (tm->tm_yday - (tm->tm_wday - 1 + 7) % 7 + 7) / 7; goto _no;
            case 'Z': src = tmzone();                          goto _str;
	    case 'z':
	              diff =gmt_off()/60;
		      if (diff >=0)
			buf[0]='+';
		      else {
			buf[0]='-';
			diff = -diff;
		      }
		      i2a ( buf+1, (unsigned int)(diff/60) );
                      i2a ( buf+3, (unsigned int)(diff%60) );
                      src = buf;
	              goto _str;
            case 'Y': i2a ( buf+0, (unsigned int)(tm->tm_year / 100 + 19) );
                      i2a ( buf+2, (unsigned int)(tm->tm_year % 100) );
                      src = buf;
                      goto _str;
            case 'y': no  = tm->tm_year % 100;                   goto _no;
                 _no: i2a ( buf, no );                           /* append number 'no' */
                      src = buf;
                      goto _str;
                _nos: i2a ( buf, no );                           /* the same, but '0'->' ' */
                      if (buf[0] == '0')
                          buf[0] = ' ';
                      src = buf;
                _str: while (*src  &&  p < dst+max)              /* append string */
                          *p++ = *src++;
                      break;
            };
        } else {
            *p++ = *format;
        }

        if (p >= dst+max)
            break;
    }

    *p = '\0';
    return p - dst;
}

#pragma GCC diagnostic pop
