
#include <cstring>
#include <sstream>
#include <openssl/md5.h>

#include <butil/digest.h>

static const unsigned md5BufSize = 16;

std::string make_hex(unsigned char* buf, size_t size) {
    char alpha[]= {'0','1','2','3','4','5','6','7','8','9','a','b','c','d','e','f'};
    unsigned char c;
    std::string res;

    for (size_t i = 0; i < size; i++) {
        c = (buf[i] & 0xf0) >> 4;
        res.push_back(alpha[c]);
        c = (buf[i] & 0xf);
        res.push_back(alpha[c]);
    }
    return res;
}

std::string md5_hex(const std::string& str) {
    unsigned char buf[md5BufSize];
    const unsigned char* data = reinterpret_cast<const unsigned char*>(str.data());
    MD5(data, str.size(), buf);
    return make_hex(buf, md5BufSize);
}

std::string md5_raw(const std::string& str) {
    unsigned char buf[md5BufSize];
    const unsigned char* data = reinterpret_cast<const unsigned char*>(str.data());
    MD5(data, str.size(), buf);
    const char* bufCasted = reinterpret_cast<const char*>(&(buf[0]));
    return std::string(bufCasted, md5BufSize);
}
