#include <sstream>
#include <butil/http/error.h>

namespace http {

std::string formatForLog(const error& e, int tryCount) {
    std::stringstream buffer;
    buffer << "host=" << e.url().server() << ":" << e.url().port() << " status=error";
    if (tryCount > 0) {
        buffer << " try=" << tryCount;
    }
    buffer << " reason=[" << e.what() << "]";
    return buffer.str();
}

std::string formatForLog(const StatusError& e, int tryCount) {
    std::stringstream buffer;
    buffer << "host=" << e.url().server() << ":" << e.url().port() << " status=" << e.status();
    if (tryCount > 0) {
        buffer << " try=" << tryCount;
    }
    buffer << " reason=[" << e.what() << "]";
    return buffer.str();
}

} // namespace http
