#include <butil/http/extract_auth_domain.h>

namespace http {

std::string extractAuthDomain(const std::string& path, const std::string& defaultValue) {
    std::string auth_domain = defaultValue;
    if ( path.find(auth_domain + ":") == std::string::npos )
    {
        std::string path_copy = path;

        std::string::size_type separator_pos = path_copy.find(":");
        if ( separator_pos != std::string::npos ) path_copy.erase(separator_pos);

        const std::string mailHostLandmark( ".yandex" );
        std::string::size_type domainStart = path_copy.rfind( mailHostLandmark );
        if ( domainStart != std::string::npos ) {
            auth_domain = path_copy.substr( domainStart );
        }
    }
    return auth_domain;
}

}
