#include <set>
#include <butil/network/domain_check.h>
#include <butil/network/idn.h>

// generate yandex hosts names
YandexDomains get_yandex_hosts( )
{
    YandexDomains result;
    result.add("yandex.ru", "ru");
    result.add("ya.ru", "ru");
    result.add("narod.ru", "ru");
    result.add("yandex.ua", "ua");
    result.add("yandex.com", "com");
    result.add("yandex.by", "by");
    result.add("yandex.kz", "kz");
    result.add("яндекс.рф", "рф");
    result.add("yandex.net", "net");
    result.add("yandex.com.tr", "com.tr");
    result.add("yandex.az", "az");
    result.add("yandex.com.am", "com.am");
    result.add("yandex.com.ge", "com.ge");
    result.add("yandex.co.il", "co.il");
    result.add("yandex.kg", "kg");
    result.add("yandex.lt", "lt");
    result.add("yandex.lv", "lv");
    result.add("yandex.md", "md");
    result.add("yandex.tj", "tj");
    result.add("yandex.tm", "tm");
    result.add("yandex.uz", "uz");
    result.add("yandex.fr", "fr");
    result.add("yandex.ee", "ee");
    return result;
}

// generate yandex-team hosts names
YandexDomains get_yandex_team_hosts( )
{
    YandexDomains result;
    result.add("yandex-team.ru", "ru");
    result.add("mail.yandex-team.ru", "ru");
    result.add("yandex-team.com", "com");
    result.add("yandex-team.com.tr", "com.tr");
    result.add("k50.ru", "ru");
    result.add("openyard.ru", "ru");
    result.add("yango.com", "com");
    result.add("meteum.ai", "ai");
    result.add("cloudil.co.il", "co.il");
    return result;
}

const YandexDomains& getYandexDomains() {
    static const YandexDomains instance = get_yandex_hosts();
    return instance;
}

const YandexDomains& getYandexTeamDomains() {
    static const YandexDomains instance = get_yandex_team_hosts();
    return instance;
}

/* check if hostName is valid yandex host name
 * @param[in] hostName checking value may be in IDNA or UTF format, doesn't matter.
 */
bool is_yandex_host(const HostName& hostName)
{
    return getYandexDomains().contains(hostName);
}

bool is_yandex_team_host ( const HostName & hostName) {
    return getYandexTeamDomains().contains(hostName);
}
