#include <cstdlib>
#include <contrib/libs/libidn/lib/idna.h>
#include <butil/network/idn.h>
#include <butil/network/rfc2822.h>

namespace idna {
    struct pointer {
        char *ptr;
        pointer(void): ptr(0) {}
        ~pointer(void) { free(ptr); }
    };

    std::string
    decode(const std::string& text) {
        pointer output;
        int result = idna_to_unicode_8z8z(text.c_str(), &output.ptr, 0);
        if (result) {
            throw std::runtime_error("cannot decode string: " + text);
        }

        return std::string(output.ptr);
    }

    std::string
    encode(const std::string& text) {
        pointer output;
        int rc = idna_to_ascii_8z(text.c_str(), &output.ptr, 0);
        if(rc != IDNA_SUCCESS)
            throw rfc2822ns::invalid_address(std::string("invalid address: ")
                                           + idna_strerror(static_cast<Idna_rc>(rc)));
        return std::string(output.ptr);
    }

    std::string
    decode_addrspec(const std::string& text) {
        std::string local, domain;
        std::string::size_type pos = 0;
        if(rfc2822ns::addrspec(text, pos, local, domain))
            return rfc2822ns::join_address(local, decode(domain));
        return text;
    }

    std::string
    encode_addrspec(const std::string& text) {
        std::string local, domain;
        std::string::size_type pos = 0;
        if(rfc2822ns::addrspec(text, pos, local, domain))
            return rfc2822ns::join_address(local, encode(domain));
        return text;
    }
}
