#include <stdexcept>
#include <boost/lexical_cast.hpp>

#include <butil/network/utils.h>

using namespace std;


std::string getHostName()
{
    char hostname[ 255 ];
    gethostname( hostname, 255 );
    return boost::lexical_cast< string >( hostname );
}

void split_domain(const string &email, string &login, string &domain)
{
    string::size_type o=email.find('@');
    if(o==string::npos) {
        login=email;
        domain.clear();
        return;
    }
    login=email.substr(0,o);
    domain=email.substr(o+1);
}
