
#include <stdexcept>

#include <butil/network/yandex_domains.h>

using namespace std;

YandexDomains::DomainInfo::DomainInfo(const string& domain, const string& topLvlDomain):
    domain(domain), topLevelDomain(topLvlDomain) {
}

YandexDomains::const_iterator YandexDomains::begin() const {
    return domains_.begin();
}

YandexDomains::const_iterator YandexDomains::end() const {
    return domains_.end();
}

void YandexDomains::add(const string& domain, const string& topLvlDomain) {
    if (contains(domain)) {
        return;
    }
    domains_.push_back(DomainInfo(idna::encode(domain), topLvlDomain));
}

bool YandexDomains::contains(const string& host) const {
    return find(host) != domains_.end();
}
