#include <cstring>
#include <vector>
#include <string>
#include <butil/thread/pthread_exception.h>

#define MAX_ERR 512

std::vector<std::string> e_msg(MAX_ERR);
static char unk_e[]="unknown error";


struct load_errors {
  load_errors();
};

static load_errors load_it;

load_errors::load_errors()
{

  for (int i=0; i<MAX_ERR; ++i) {
    const char* em = strerror(i);
    if (em) {
      e_msg[i] = em;
    } else {
      e_msg[i] = unk_e;
    }
  }
}


const char*
b_strerror(int e)
{
  if (e > MAX_ERR || e < 0) {
    return unk_e;
  } else {
    return e_msg[e].c_str();
  }
}
