#include <butil/xml/entities.h>

namespace {
static const XmlEntities entities;
}

std::string & decodeXmlEntities( std::string & src ) {
    for(XmlEntityIterator i(src), last; i!=last; ++i ) {
        const std::string::size_type pos = i.first - i.beginPattern.length();
        const std::string::size_type len = i.last - pos + i.endPattern.length();
        char glyph = entities.glyph(*i);
        if (glyph) {
            src.replace(pos, len, 1, glyph);
            i.last = i.first;
        }
    }
    return src;
}

std::string& encodeXmlEntities(std::string& src) {
    for (size_t pos = 0; pos < src.size(); ++pos) {
        std::string entity = entities.entity(src[pos]);
        if (entity.empty()) {
            continue;
        }
        entity = "&" + entity + ";";
        src.replace(pos, 1, entity);
        pos += entity.size() - 1;
    }
    return src;
}
