#include <butil/xml/entities.h>
#include <butil/xml/routines.h>
#include <boost/lexical_cast.hpp>
#include <boost/algorithm/string/find_iterator.hpp>
#include <boost/algorithm/string/finder.hpp>

std::string xmlOpenTag(const std::string& tag, const XmlAttrs& attrs) {
    std::ostringstream ss;
    ss << "<" << tag;
    if (!attrs.empty()) {
        for (XmlAttrs::const_iterator iter = attrs.begin(); iter != attrs.end(); ++iter) {
            std::string attrValue = iter->second;
            std::string attrName = iter->first;
            ss << " " << attrName << "=\"" << encodeXmlEntities(attrValue) << '\"';
        }
    }
    ss << ">";
    return ss.str();
}

std::string xmlWrap(const std::string& tag, const std::string& content, const XmlAttrs& attrs) {
    std::ostringstream ss;
    std::string openTag = xmlOpenTag(tag, attrs);
    ss << openTag.substr(0, openTag.size() - 1);
    if (content.empty()) {
        ss << "/>";
    } else {
        ss << ">";
        ss << content;
        ss << "</" << tag << ">";
    }
    return ss.str();
}

namespace butil {

std::string getXmlHeader(const std::string& str) {
    size_t start = str.find("<?");
    if (start == std::string::npos) {
        return "";
    }
    size_t end = str.find("?>", start);
    if (end == std::string::npos) {
        return "";
    }
    return str.substr(start, end-start+2);
}

std::string getXmlEncoding(const std::string& str) {
    static constexpr char defolt[] = "utf-8";
    const std::string header = getXmlHeader(str);
    if (header.empty()) {
        return defolt;
    }
    const std::string clearedHeader = header.substr(2, header.size() - 4);

    using namespace boost::algorithm;
    typedef split_iterator<std::string::const_iterator> SplitIterator;
    const std::string encodingAttr = "encoding=";

    for (SplitIterator it = make_split_iterator(clearedHeader, first_finder(" ", is_iequal())); it != SplitIterator(); ++it) {
        const std::string attr = boost::copy_range<std::string>(*it);
        const size_t encodingPos = attr.find(encodingAttr);
        if (encodingPos != std::string::npos) {
            std::string encoding = attr.substr(encodingPos + encodingAttr.size());
            encoding.erase(std::remove(encoding.begin(), encoding.end(), '"'), encoding.end());
            if (!encoding.empty()) {
                return encoding;
            }
        }
    }
    return defolt;
}

} // namespace
