LIBRARY()

OWNER(
    g:mail
)

NO_UTIL()

PEERDIR(
    contrib/restricted/boost/libs
    contrib/libs/libiconv
    contrib/libs/libidn
    contrib/libs/libxml
    contrib/libs/zlib
    contrib/libs/expat
    mail/recipient_parser
    library/cpp/geobase
    contrib/libs/pcre
)

CFLAGS(
    GLOBAL -DARCADIA_BUILD
)

ADDINCL(
    GLOBAL mail/butil/include
    GLOBAL contrib/libs/pcre
    GLOBAL contrib/libs/expat
    GLOBAL contrib/libs/libiconv/include
)

SRCS(
    src/butil.cc
    src/crypt.cc
    src/datetime/date_utils.cc
    src/datetime/timezone.cc
    src/datetime/util_date.cc
    src/digest.cc
    src/email/helpers.cc
    src/email/yandex_login.cc
    src/Expat.cc
    src/http/error.cc
    src/http/extract_auth_domain.cc
    src/http/url.cc
    src/http/url_proto.cc
    src/network/domain_check.cc
    src/network/idn.cc
    src/network/rfc2822.cc
    src/network/utils.cc
    src/network/yandex_domains.cc
    src/strtools.cc
    src/StrUtils/Encoding.cc
    src/StrUtils/Iconv.cc
    src/StrUtils/pystrutils.cc
    src/StrUtils/StrUtils.cc
    src/StrUtils/ToLower.cc
    src/StrUtils/utfutils.cc
    src/thread/pthread_exception.cc
    src/xml/entities.cc
    src/xml/routines.cc
)

END()

RECURSE(
    tests
)
