#!/bin/bash

if [ -z $ACTIVE_PROCESSOR_COUNT ];then
    export ACTIVE_PROCESSOR_COUNT=${QLOUD_CPU_LIMIT/.*}
fi

if [ -z $ENVIRONMENT_TYPE ];then
    export ENVIRONMENT_TYPE=$QLOUD_ENVIRONMENT
fi

if [ -z $FALLBACK_ADDRESS ];then
    echo "ERROR! Variable FALLBACK_ADDRESS is not provided. Please provide the fallback address"
    exit 1
fi

. /usr/lib/qloud-mail-common.sh
check_ephemeral && (
  qloud_link /var/log/caldavos
  qloud_link /var/log/nginx
  qloud_link /var/heapdumps    
)

mkdir -p /etc/nginx/sites-enabled/

# Это нужно, чтобы срабатывала ротация каждый час - это наиболее безопасный способ, см. детали здесь https://unix.stackexchange.com/a/366468
chmod 755 /etc/cron.daily/logrotate && dpkg-divert --add --rename --divert /etc/cron.hourly/logrotate /etc/cron.daily/logrotate

ln -svf /etc/supervisor/app.conf /etc/supervisor/conf.d/
cp -v /etc/nginx/sites-available/app.conf /etc/nginx/sites-enabled/

sed -i "s/fallback_address/$FALLBACK_ADDRESS/g" /etc/nginx/sites-enabled/app.conf

# If certificate exists, link it and listen to ssl ports
if [ -f /etc/nginx/ssl/caldavos.pem ]; then
    ln -svf /etc/nginx/includes/caldavos_ssl /etc/nginx/includes/caldavos_ssl.safe
fi

exec "$@"
