# Общее описание

Данный проект является асинхронным Caldav сервером. 

Проект работает на основе micronaut фреймворка, который уже достаточно хорошо зарекомендовал себя при разработке mail/cerberus. 

На данный момент проект не содержит какой-то собственной базы данных, а работает с базой календаря через API календаря (для этого используется специальный асинхронный клиент от micronaut). Впоследствии необходимо будет вынести это из базы календаря и использовать свою собственную (на основе чего-нибудь также асинхронного).

В качестве непосредственно парсера для сообщений в стиле Icalendar используется ICal4j, для управления уровнем webdav используется webdav слой от Apache Jackrabbit.  По умолчанию jackrabbit работает на основе синхронных сервлетов, однако в данном проекте используется без таковых сервлетов, чтобы обеспечить асинхронность и масштабируемость.  При этом сам слой webdav считает что он использует сервлеты, и пытается в них отправлять статусы ошибок и тексты, закрывая при этом поток вывода сразу в случае отправки ошибки. В реальности же micronaut отлавливает эти отправки и асинхронно отдает их клиентам.

Может возникнуть вопрос, почему мы вообще используем jackrabbit. Нельзя ли написать все самим? Проблема в том, что тогда придется заодно написать генерацию в XML-формате тела ответов, и это помимо того, что нужно будет прописывать взаимодействие с API календаря. Проще выглядит вариант, когда micronaut ловит вызовы методов от слоя webdav, и дальше их куда-то транслировать, вместо того, чтобы самостоятельно генерировать все эти ответы.