import os

TESTS_ROOT = 'mail/calendar-attach-processor/tests/'


def is_arcadia():
    try:
        import __res
        assert __res
        return True
    except ImportError:
        pass
    import sys
    return hasattr(sys, "extra_modules")


def test_path(input_path, test_file, data_filename):
    if is_arcadia():
        import yatest.common
        input_dir = yatest.common.source_path(TESTS_ROOT + input_path)
        return os.path.join(input_dir, data_filename)
    else:
        test_dir = os.path.dirname(test_file)
        return os.path.join(test_dir, 'input', data_filename)
