from collections import namedtuple

import requests

Subscriber = namedtuple('Subscriber', ('email', 'inbox', 'login'))


class MlError(Exception):
    pass


class Maillist(object):
    def __init__(self, url, session, timeout=10):
        self.url = url
        self._session = session
        self.timeout = timeout

    def expand_maillists(self, ml_email):
        ml_params = {'expand': "yes", 'emails': ml_email}
        try:
            resp = self._session.request('get', self.url, params=ml_params)
            return self.get_subscribers(resp.json(), ml_email)
        except (ValueError, AttributeError, requests.HTTPError) as err:
            raise MlError(err)

    @staticmethod
    def get_subscribers(as_json, ml_email):
        ml = as_json.get('result', {}).get(ml_email, {})
        subscribers = ml.get('subscribers', [])

        return map(lambda subscriber: Subscriber(subscriber.get('email', ""),
                                                 subscriber.get('inbox', False),
                                                 subscriber.get('login', "")),
                   subscribers)
