import requests
from requests.adapters import HTTPAdapter
from requests.exceptions import RetryError, ConnectionError, ConnectTimeout, SSLError, ReadTimeout, Timeout
from requests.status_codes import _codes
from urllib3 import Retry

# Http status codes for retry
RETRY_STATUS_CODES = filter(lambda code: code >= 500, _codes.keys())

# A backoff factor to apply between attempts after the second try. If the backoff_factor is 0.1,
# then :func:`.sleep` will sleep for [0.0s, 0.2s, 0.4s, ...] between retries.
BACKOFF_FACTOR = 0.2


def retry_session(retries_num=2, status_forcelist=RETRY_STATUS_CODES):
    session = requests.Session()
    retries = Retry(total=retries_num,
                    backoff_factor=BACKOFF_FACTOR,
                    status_forcelist=status_forcelist)
    session.mount('http://', HTTPAdapter(max_retries=retries))
    session.mount('https://', HTTPAdapter(max_retries=retries))
    return session


def http_request(url,
                 session=requests.session(),
                 method="get",
                 params=None,
                 headers=None,
                 data=None,
                 timeout=2):
    url_encode = url.encode('utf-8')
    try:
        response = session.request(method, url_encode, data=data, headers=headers, params=params, timeout=timeout)
        response.raise_for_status()
        return response
    except (ConnectionError, ReadTimeout, ConnectTimeout, Timeout, SSLError,  SSLError, RetryError) as err:
        raise requests.HTTPError(err)
