# -*- coding: utf-8 -*-

from setuptools import setup, find_packages


def version(package):
    import os
    import subprocess
    import re

    # Fetch version from git tags, and write to __version__.py.
    # Also, when git is not available (PyPi package), use stored __version__.py.
    version_py = os.path.join(os.path.dirname(__file__), package, '__version__.py')

    try:
        __version__ = re.sub('^v', '', subprocess.check_output(["git", "describe", "--tags"]).rstrip().decode("utf-8"))
    except:
        import importlib
        __version__ = importlib.import_module('{package}.__version__'.format(package=package)).__version__

    with open(version_py, 'w') as version_file:
        version_file.write('''# Do not edit this file, autogenerated from git tags
__version__ = '%s'
''' % __version__)

    return __version__


setup(
    name='calendar-attach-processor',
    author='Nastassia Klishevich',
    description='Sends to calendar all calendar/ics attaches to create meetings',
    long_description=open('README.md').read(),
    author_email='stassiak@yandex-team.ru',
    version=version('calendar_attach_processor'),
    url='https://github.yandex-team.ru/mail/calendar-attach-processor',
    packages=find_packages(exclude=('tests', 'tests.*')),
    install_requires=[
        'cachetools',
        'flanker',
        'blackboxer==2.0.0'
    ]
)
