# -*- coding: UTF-8 -*-

import json
import os
import re
from urllib.request import urlopen, Request

ENVIRONMENT_FILE = "/etc/qloud/meta.json"

QLOUD_KEY_FILE = "/etc/qloud.key"
QLOUD_API = 'https://qloud-ext.yandex-team.ru/api/v1/status/'
DEPLOY_STAGE_ID = os.getenv("DEPLOY_STAGE_ID")

class environment(dict):
    def __init__(self):
        self.update(json.load(open(ENVIRONMENT_FILE)))
        self.user = self["user_environment"]
        self.is_corp = True if re.search("-corp$", self["qloud_application"]) else False


environ = environment() if not os.getenv("DEPLOY_PROJECT_ID") else {}


if not DEPLOY_STAGE_ID:
    qloud_application = environ.user["QLOUD_APPLICATION"]
    environment = environ.user["QLOUD_ENVIRONMENT"]
    application =f"{environ.user['QLOUD_PROJECT']}.{qloud_application}"
else:
    app_env, environment = DEPLOY_STAGE_ID.split("_")[-2:]
    qloud_application = f"calendar-{app_env}"
    application = f"mail.{qloud_application}"


def get_qloud_token():
    if DEPLOY_STAGE_ID:
        return os.getenv("QLOUD_OAUTH_TOKEN")

    with open(QLOUD_KEY_FILE) as f:
        return f.read().strip()


def get_qloud_instances(qloud_path, dc=False, name=False):
    qloud_token = get_qloud_token()
    request = Request(QLOUD_API + qloud_path,
                      headers={"Authorization": "OAuth " + qloud_token})
    contents = json.loads(urlopen(request).read())
    instances = []
    for instance in contents:
        if instance['instanceCurrentState'] == 'ACTIVE':
            if dc:
                instances.append(
                    {'fqdn': instance['instanceFqdn'], 'dc': instance['dc']})
                continue
            if name:
                instances.append(
                    {'fqdn': instance['instanceFqdn'], 'name': instance['instanceName']})
                continue
            instances.append(instance['instanceFqdn'])
    return instances
