### Введение

Данный набор тестов обращается (пока что) по протоколу CalDAV к тестовому стенду большого календаря, и пытается выполнить набор действий для проверки того, что мы соответствуем compliance. Основано на [ccs-caldavtester](https://github.com/apple/ccs-caldavtester/).

## Пререквизиты

### Учетная запись

Выполняются все эти действия от имени пользователя caldavcompluser, который был заведен в большом паспорте, прописан в [Sandbox vault](https://sandbox.yandex-team.ru/admin/vault?name=caldavcompluser&limit=20), а также доступен в [секретнице](https://yav.yandex-team.ru/secret/sec-01dchgbb8t9xv0s1fjtfb8bhg6/explore/versions).

Для локального запуска надо прописать пароль из секретницы в файле на локальной машине и в переменной окружения с названием CALDAV_USER_TOKEN_PATH прописать путь до этого файла.

### Ресурсы от Sandbox

На данный момент папки scripts и Resources из исходного проекта [ccs-caldavtester](https://github.com/apple/ccs-caldavtester/), требуемые данному проекту, помещены в Sandbox-ресурсы из-за их большого размера. Возможно, scripts стоит утащить в аркадию, чтобы на конкретные тест-кейсы можно было посмотреть не заглядывая в sandbox.

### Настройка параметров тестов

Настройка происходит через файл mail/calendar/python/caldav_tests_runner/serverinfo_template.xml. 
За основу взят тот же файл, что содержится в исходном проекте, но:
* Из всех поддерживаемых фич поддерживается только caldav (нужно разбираться что ещё мы можем и постепенно включать).
* В качестве пользователя везде добавлен caldavcompluser.
* В качестве сервера прописан наш публичный тестинг.

### Сетевое взаимодействие

Естественно, запуская это с локальной машины, нужно убедиться, что с этой машины есть доступ до нужного адреса:

> curl https://caldav.testing.yandex.ru/ping -v

## Запуск тестов
Часть тестов сгенерирована автоматически на основании ccs-caldavtester. По-факту добавлены только точки входа в тесты исходного проекта и навешены xfail на те тесты, которые на данный момент не проходят. Для тестов, которые исходный проект помечал как проигнорированные, точек входа пока не создавалось.
### Автогенерированные тесты (./generated)
Итак, логика тестов такова:
- Сначала они перезаписывают serverinfo.xml, заполняя значение CALDAV_USER_TOKEN реальным паролем. 
- Затем запускают тестирование для заданного xml-файла и сохраняют результаты в переменную класса.
- Каждый тест-кейс обращается к переменной класса, забирает оттуда результат и, если нужно, фейлится с кратким сообщением.

Каждый тестовый файл соответствует одной исходной xml и является по-факту просто точкой входа в тесты исходного проекта. Прогон тестов на каждом из файлов осуществляется только один раз - при загрузке класса.

Все тесты лежат в папке tests. Не меняйте их вручную, они генерируются автоматически (см. ниже)!!!

### Генерация тестов (./generator)

При необходимости (например если что-то новое начали поддерживать) тесты можно перегенирировать. Скрипт лежит в подпапке generator и использует ту же самую библиотеку.

Для генерации тестов нужно:
- запусить сборку в директории calendar/caldav-ut/generator (ya make)
- запустить собранную программу (./generator)
- забрать папку tests целиком и утащить её в caldav-ut/generated
Если всё пройдет хорошо, то обновленные тесты должны начать автоматически запускаться по 'ya make -ttt' в caldav-ut/generated. При этом все тесты должны проходить (часть по xfail).

Схема работы такая:
- запускаем тестирование для всех файликов сразу,
- для тех файлов, в которых есть хотя бы один не проигнорированный системой тест-кейс, создаем соответствующий питоновский файл,
- все не заигноренные тест-кейсы записываем в него, при этом завалившиеся помечаем xfail,
- создаем файл ya.make.inc, в котором регистрируем каждый из созданных тестовых файлов.

### Вручную написанные тесты (./handwritten)
Тесты можно также дописывать и вручную. Схема работы таких тестов:
- передача необходимых скриптов и ресурсов caldav_tests_runner-у (он сохранит их у себя рядом с файлами исходного проекта),
- запуск теста через эту же библиотечку (библиотека сама разберется с необходимыми ресурсами и настроит serverinfo.xml), настроить самим нужно только пароль,
- если хотя бы один из тестов в xml-файле не пройдет - фейл всего теста (это при желании можно переделать на такую же схему как и с автогенеренными).
