package ru.yandex.calendar.generate;

import lombok.val;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Pattern;

public class GenerateDb {
    private static final Pattern tablePattern2 = Pattern.compile("(?<!IGNORE\\n)(CREATE TABLE[\\S\\s]+?\\);)");

    public static void main(String[] args) throws IOException {
        val migrationDirectory = new File(args[0]);
        val outputDirectory = new File(args[1]);
        if (!(migrationDirectory.exists() && migrationDirectory.isDirectory())) {
            throw new RuntimeException("Directory with database migrations don't exists");
        }
        if (!outputDirectory.exists()) {
            outputDirectory.mkdirs();
        }
        ArrayList<Bean> tables = new ArrayList<Bean>();
        Arrays.stream(migrationDirectory.listFiles()).filter(File::isFile).forEach(
            fileEntry -> {
                String content = "";
                try {
                    content = new String(Files.readAllBytes(fileEntry.toPath()), StandardCharsets.UTF_8);
                } catch (IOException e) {
                    throw new RuntimeException(e);
                }
                val m = tablePattern2.matcher(content);
                while (m.find()) {
                    tables.add(new Bean(m.group()));
                }
            }
        );

        for (Bean table : tables) {
            table.parseTable();
            table.printBeanToFile(outputDirectory);
            table.printBeanFieldsToFile(outputDirectory);
            table.printBeanHelperToFile(outputDirectory);
        }
    }
}
