
CREATE TYPE job_status AS ENUM ('ready', 'starting', 'running', 'completed', 'failed', 'expired');

-- IGNORE
CREATE TABLE job (
    id UUID NOT NULL,
    task TEXT NOT NULL,
    create_time TIMESTAMP NOT NULL,

    active_uid TEXT,
    parameters JSONB NOT NULL,

    status job_status NOT NULL,

    schedule_time TIMESTAMP NOT NULL,
    priority INTEGER NOT NULL,

    worker_id TEXT,

    start_time TIMESTAMP,
    finish_time TIMESTAMP,
    cpu_usage SMALLINT,

    attempt INTEGER,
    error_message TEXT,
    error_stack_trace TEXT,

    CONSTRAINT pk_job PRIMARY KEY (id),
    CONSTRAINT check_task_length CHECK (char_length(task) <= 256),
    CONSTRAINT check_active_uid_length CHECK (char_length(active_uid) <= 512)
);

CREATE UNIQUE INDEX uk_job_active_uid ON job (active_uid) WHERE active_uid IS NOT NULL;
CREATE INDEX i_job_task_status_priority_schedule_time ON job (task, status, priority DESC, schedule_time);

-- IGNORE
CREATE TABLE task_stats (
    task TEXT NOT NULL,
    stats JSONB NOT NULL,

    CONSTRAINT pk_task_stats PRIMARY KEY (task),
    CONSTRAINT check_task_length CHECK (char_length(task) <= 256)
);

-- IGNORE
CREATE TABLE cron_job (
    task TEXT NOT NULL,
    create_time TIMESTAMP NOT NULL,

    status job_status NOT NULL,

    worker_id TEXT,
    start_time TIMESTAMP,
    finish_time TIMESTAMP,

    cpu_usage SMALLINT,
    error_message TEXT,
    error_stack_trace TEXT,

    execution_info JSONB,

    CONSTRAINT pk_cron_job PRIMARY KEY (task, create_time),
    CONSTRAINT check_task_length CHECK (char_length(task) <= 256)
);

-- IGNORE
CREATE TABLE cron_task (
    task TEXT NOT NULL,
    data JSONB NOT NULL,

    CONSTRAINT pk_cron_task PRIMARY KEY (task),
    CONSTRAINT check_task_length CHECK (char_length(task) <= 256)
);

-- IGNORE
CREATE TABLE cron_task_stats (
    task TEXT NOT NULL,
    stats JSONB NOT NULL,

    CONSTRAINT pk_cron_task_stats PRIMARY KEY (task),
    CONSTRAINT check_task_length CHECK (char_length(task) <= 256)
);
