CREATE TABLE mailer_event (
    uid BIGINT NOT NULL,       -- _ID JAVA_TYPE=PassportUid
    external_id TEXT NOT NULL, -- _ID
    instance_id BIGINT NOT NULL, -- _ID

    start_ts TIMESTAMP NOT NULL,
    end_ts TIMESTAMP NOT NULL,
    is_all_day BOOLEAN NOT NULL,

    repetition JSONB,          -- JAVA_TYPE=MailerRepetition
    recurrence_id TIMESTAMP,
    timezone_id TEXT NOT NULL,

    name TEXT NOT NULL,
    description TEXT,
    location TEXT,
    url TEXT,

    organizer JSONB,           -- JAVA_TYPE=MailerParticipant
    attendees JSONB NOT NULL,  -- JAVA_TYPE=MailerAttendees

    sequence INTEGER NOT NULL,
    dtstamp TIMESTAMP NOT NULL,

    created TIMESTAMP NOT NULL,
    modified TIMESTAMP NOT NULL,

    CONSTRAINT pk_mailer_event PRIMARY KEY (uid, external_id, instance_id),

    CONSTRAINT check_mailer_event_external_id_length CHECK (char_length(external_id) <= 512)
);
