package ru.yandex.calendar;

import javax.sql.DataSource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.support.TransactionSynchronizationManager;

import ru.yandex.calendar.util.conf.CalendarMasterSlaveContextHolder;
import ru.yandex.misc.db.DataSourceUtils;
import ru.yandex.misc.lang.Check;

/**
 * @author gutman
 */
public class CalendarDataSourceStatus {

    @Autowired
    private DataSource dataSource;

    public boolean isMasterUnavailable() {
        return CalendarMasterSlaveContextHolder.isForceMasterUnavailable() || DataSourceUtils.isReadOny(dataSource);
    }

    public void setForceMasterUnavailable(boolean unavailable) {
        CalendarMasterSlaveContextHolder.setForceMasterUnavailable(unavailable);
    }

    public boolean isInTransaction() {
        return TransactionSynchronizationManager.getResource(dataSource) != null;
    }

    public void checkIsInTransaction() {
        Check.isTrue(isInTransaction(), "Not is in transaction");
    }
}
