package ru.yandex.calendar;

import javax.annotation.Nullable;

import lombok.AccessLevel;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Value;
import lombok.With;

import ru.yandex.calendar.logic.event.ActionInfo;
import ru.yandex.misc.cache.tl.TlCache;
import ru.yandex.misc.log.reqid.RequestIdStack;
import ru.yandex.misc.support.tl.ThreadLocalHandle;
import ru.yandex.misc.thread.WhatThreadDoes;

@Value
@EqualsAndHashCode(callSuper = false)
public class CalendarRequestHandle extends ThreadLocalHandle {
    static ThreadLocal<CalendarRequestHandle> current = new ThreadLocal<>();

    @Nullable
    @Getter(AccessLevel.NONE)
    CalendarRequestHandle prev;

    @Getter(AccessLevel.NONE)
    RequestIdStack.Handle requestIdStackHandle;

    @Getter(AccessLevel.NONE)
    TlCache.Handle tlCacheHandle;

    @Getter(AccessLevel.NONE)
    WhatThreadDoes.Handle wtdHandle;

    RemoteInfo remoteInfo;
    @With ActionInfo actionInfo;

    @Override
    public void pop() {
        wtdHandle.popSafely();
        requestIdStackHandle.popSafely();
        tlCacheHandle.popSafely();
        current.set(prev);
    }
}
