package ru.yandex.calendar;

import lombok.experimental.UtilityClass;

import ru.yandex.calendar.micro.l10n.Language;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.mail.cerberus.Uid;

@UtilityClass
public class MicroCoreCompat {
    public static Language convert(ru.yandex.calendar.logic.user.Language value) {
        switch (value) {
            case RUSSIAN:     return Language.RUSSIAN;
            case ENGLISH:     return Language.ENGLISH;
            case TURKISH:     return Language.TURKISH;
            case TATAR:       return Language.TATAR;
            case UKRAINIAN:   return Language.UKRAINIAN;
            case AZERBAIJANI: return Language.AZERBAIJANI;
            case BELARUSIAN:  return Language.BELORUSSIAN;
            case ARMENIAN:    return Language.ARMENIAN;
            case GEORGIAN:    return Language.GEORGIAN;
            case ROMANIAN:    return Language.ROMANIAN;
            case KAZAKH:      return Language.KAZAKH;
        }

        throw new IllegalArgumentException("Unexpected language value: " + value);
    }

    public static Language convert(ru.yandex.inside.utils.Language value) {
        switch (value) {
            case ENGLISH:   return Language.ENGLISH;
            case RUSSIAN:   return Language.RUSSIAN;
            case UKRAINIAN: return Language.UKRAINIAN;
            case TURKISH:   return Language.TURKISH;
        }

        throw new IllegalArgumentException("Unexpected language value: " + value);
    }

    public static Uid convert(PassportUid value) {
        return new Uid(value.getUid());
    }
}
