package ru.yandex.calendar;

import ru.yandex.calendar.logic.svc.SvcRoutines;

public enum PropName {
    // With calendar-dot prefix added
    ADD_SID_TO_PASSPORT("addSidToPassport"),
    DUMP_REQUEST("dump.request"),
    DUMP_RESPONSE("dump.response"),
    //DUMP_XSL_INPUT("dump.xsl.input"),
    //DUMP_XSL_OUTPUT("dump.xsl.output"),
    //IGNORE_PROC_ERRORS("ignore.processing.errors"),
    OUTPUT_ENC("output.encoding"),
    STATS_TO_LOG("stats.to.log"),
    SUPPRESS_LOG("suppress.log"), // affects helper log only for now
    // Other property names
    AUTH_DOMAINS(false, "auth.domains"),
    ETC_DIR(false, "etc.dir");

    // The rest properties
    // (workaround for 'The value for annotation attribute Value.value must be a constant expression' error)
    public static final String DUMP_XSL_INPUT_ANNOT_VALUE = "${calendar.dump.xsl.input}";
    public static final String DUMP_XSL_OUTPUT_ANNOT_VALUE = "${calendar.dump.xsl.output}";

    private final String propName;

    /**
     * Creates property name from a given suffix, adding calendar-dot prefix
     */
    PropName(String suffix) {
        this(true, suffix);
    }
    /**
     * Creates property name using a given suffix and, probably, calendar-dot prefix
     * @param withCalendarPrefix whether prefix is to add
     */
    PropName(boolean withCalendarPrefix, String suffix) {
        this.propName = (withCalendarPrefix ? SvcRoutines.CALENDAR_NAME + "." : "") + suffix;
    }

    public String get() {
        return propName;
    }
}
