package ru.yandex.calendar;

import lombok.AllArgsConstructor;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.ip.IpAddress;

@AllArgsConstructor
public class RemoteInfo {
    public final Option<IpAddress> ip;
    public final Option<String> yandexuid;
    public final Option<String> connectionId;

    public RemoteInfo(Option<IpAddress> ip, Option<String> yandexuid) {
        this(ip, yandexuid, Option.empty());
    }

    @Override
    public String toString() {
        return "RemoteInfo{" +
                "ip=" + ip +
                ", yandexuid=" + yandexuid +
                ", connectionId=" + connectionId +
                '}';
    }
}
