package ru.yandex.calendar.admin;

import java.util.Collections;

import lombok.val;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.calendar.admin.displays.DisplaysAdminContextConfiguration;
import ru.yandex.calendar.admin.event.EventAdminContextConfiguration;
import ru.yandex.calendar.admin.exchange.ExchangeAdminContextConfiguration;
import ru.yandex.calendar.admin.resources.ResourcesContextConfiguration;
import ru.yandex.calendar.admin.specialusers.SpecialUsersAdminContextConfiguration;
import ru.yandex.calendar.admin.user.UserAdminContextConfiguration;
import ru.yandex.calendar.frontend.mulca.MulcagateContextConfiguration;
import ru.yandex.calendar.frontend.ywmi.YmiContextConfiguration;
import ru.yandex.calendar.logic.domain.PassportAuthDomainsHolder;
import ru.yandex.calendar.tvm.AddRequestTvmHeaderInterceptor;
import ru.yandex.calendar.tvm.TvmClient;
import ru.yandex.commune.admin.web.Admin;
import ru.yandex.commune.admin.web.AdminBasicContextConfiguration;
import ru.yandex.commune.admin.web.auth.AdminAuthenticationConfiguration;
import ru.yandex.commune.alive2.AliveAppsContextConfiguration;
import ru.yandex.commune.alive2.admin.AliveAppsAdminContextConfiguration;
import ru.yandex.commune.db.admin.dbs.DbsContextConfiguration;
import ru.yandex.commune.db.admin.sql.SqlContextConfiguration;
import ru.yandex.commune.dynproperties.admin.DynamicPropertiesAdminContextConfiguration;
import ru.yandex.commune.monica.MonicaClientContextConfiguration;
import ru.yandex.commune.script.cosher.nashorn.NashornInterpreterFactory;
import ru.yandex.commune.script.cosher.server.ScriptTelnetServer;
import ru.yandex.commune.zk2.admin.ZkAdminContextConfiguration;
import ru.yandex.inside.admin.conductor.Conductor;
import ru.yandex.inside.admin.conductor.ConductorGroup;
import ru.yandex.misc.env.EnvironmentType;
import ru.yandex.misc.io.exec.ProcessUtils;
import ru.yandex.misc.monica.MonicaConfiguration;
import ru.yandex.misc.monica.core.name.LocalMetricNamespace;
import ru.yandex.misc.net.HostnameUtils;
import ru.yandex.misc.thread.TltServlet;
import ru.yandex.misc.version.AppName;
import ru.yandex.misc.web.servlet.PidServlet;
import ru.yandex.misc.web.servlet.WtdFilter;
import ru.yandex.misc.web.servletContainer.SingleWarJetty;
import ru.yandex.passport.tvmauth.BlackboxTvmId;

@Configuration
@Import({
        AdminBasicContextConfiguration.class,
        DbsContextConfiguration.class,
        SqlContextConfiguration.class,
        EventAdminContextConfiguration.class,
        ExchangeAdminContextConfiguration.class,
        UserAdminContextConfiguration.class,
        ResourcesContextConfiguration.class,
        DisplaysAdminContextConfiguration.class,
        SpecialUsersAdminContextConfiguration.class,
        ZkAdminContextConfiguration.class,
        AliveAppsAdminContextConfiguration.class,
        AliveAppsContextConfiguration.class,
        DynamicPropertiesAdminContextConfiguration.class,
        MonicaClientContextConfiguration.class,
        YmiContextConfiguration.class,
        MulcagateContextConfiguration.class,
})
public class CalendarAdminContextConfiguration {
    @Value("${admin.jetty.http.port}")
    private int jettyHttpPort;
    @Value("${script_telnet_server.port}")
    private int scriptTelnetServerPort;
    @Autowired
    private TvmClient tvmClient;

    @Bean
    public AdminAuthenticationConfiguration adminAuthenticationConfiguration() {
        val conf = new AdminAuthenticationConfiguration();
        conf.addNoAuthUriPatternsForLocalhost("/*");
        conf.addNoAuthUriPatterns("/z/displays/.json", "/z/displays.json");
        conf.setInterceptors(Collections.singletonList(new AddRequestTvmHeaderInterceptor(BlackboxTvmId.PROD_YATEAM.getDstTvmId(), tvmClient)));
        return conf;
    }

    @Bean
    @Admin
    public SingleWarJetty singleWarJetty() {
        val singleWarJetty = new SingleWarJetty();
        singleWarJetty.setMaxThreads(30);
        singleWarJetty.setHttpPort(jettyHttpPort);
        singleWarJetty.setLookupServletsInContext(true); // XXX: evil
        singleWarJetty.addServletMapping("/pid/*", new PidServlet());
        singleWarJetty.addServletMapping("/ping/*", webPinger());
        return singleWarJetty;
    }

    @Bean
    public ScriptTelnetServer scriptTelnetServer() {
        return new ScriptTelnetServer(new NashornInterpreterFactory(), scriptTelnetServerPort, false);
    }

    @Bean
    public CalendarPingServlet webPinger() {
        return new CalendarPingServlet();
    }

    @Bean
    public WtdFilter wtdFilter() {
        return new WtdFilter();
    }

    @Bean
    public TltServlet tltServlet() {
        return new TltServlet();
    }

    @Bean
    public BeanXmlizerForAdmin beanXmlizerForAdmin() {
        return new BeanXmlizerForAdmin();
    }

    @Bean
    public GiftManager giftManager() {
        return new GiftManager();
    }

    @Bean
    public MailAdminManager mailAdminManager() {
        return new MailAdminManager();
    }

    @Bean
    public MonicaConfiguration monicaConfiguration(
            EnvironmentType environmentType, AppName appName,
            PassportAuthDomainsHolder passportAuthDomainsHolder, Conductor conductor)
    {
        val hostname = HostnameUtils.localHostname();
        val environment = environmentType.getValue() + "-" + passportAuthDomainsHolder.asString();

        return new MonicaConfiguration(new LocalMetricNamespace(
                environment,
                appName.serviceName(),
                appName.appName(),
                conductor.getGroupIfExists(hostname).map(ConductorGroup::getName).getOrElse("unknown"),
                conductor.getDcNameIfExists(hostname).getOrElse("unknown"),
                HostnameUtils.localHostname(),
                ProcessUtils.getPid()
        ));
    }
}
