package ru.yandex.calendar.admin;

import java.io.IOException;

import javax.annotation.PostConstruct;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.joda.time.Instant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.admin.export.ExportManager;
import ru.yandex.calendar.admin.export.ExportServlet;
import ru.yandex.commune.admin.web.Admin;
import ru.yandex.commune.admin.web.AdminApp;
import ru.yandex.commune.admin.web.AdminBender;
import ru.yandex.commune.admin.web.AdminConfigurator;
import ru.yandex.commune.admin.web.AdminGroups;
import ru.yandex.commune.admin.web.info.InfoAdminPage;
import ru.yandex.commune.admin.web.version.VersionHolder;
import ru.yandex.commune.admin.z.template.TemplateEngine;
import ru.yandex.misc.env.EnvironmentType;
import ru.yandex.misc.version.AppName;
import ru.yandex.misc.version.Version;
import ru.yandex.misc.web.servletContainer.SingleWarJetty;

/**
 * @author dbrylev
 */
@Configuration
public class CalendarModeratorContextConfiguration {

    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private AppName appName;
    @Autowired(required = false)
    private Version version;
    @Autowired
    private EnvironmentType environmentType;

    @Value("${web.moderator.jetty.http.port}")
    private int jettyHttpPort;

    @Bean
    @Admin
    public SingleWarJetty singleWarJetty() {
        SingleWarJetty singleWarJetty = new SingleWarJetty();
        singleWarJetty.setMaxThreads(30);
        singleWarJetty.setHttpPort(jettyHttpPort);
        singleWarJetty.addServletMapping("/export/*", exportServlet());
        singleWarJetty.addServletMapping("/*", makeMeZServlet());
        singleWarJetty.setLookupServletsInContext(false);
        return singleWarJetty;
    }

    private Servlet makeMeZServlet() {
        return new HttpServlet() {
            public void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                resp.sendRedirect("/z");
            }
        };
    }

    @Admin
    @Bean
    public AdminApp adminApp() {
        return AdminConfigurator.configure("/z",
                singleWarJetty()::addServletMapping, AdminBender.mapper, Cf.<TemplateEngine>list(),
                Option.of(environmentType));
    }

    @Bean
    public ExportManager exportManager() {
        return new ExportManager();
    }

    @Bean
    public ExportServlet exportServlet() {
        return new ExportServlet();
    }

    @Bean
    public VersionHolder versionHolder() {
        return new VersionHolder(Option.ofNullable(version));
    }

    @PostConstruct
    public void configure() {
        Instant startup = new Instant(applicationContext.getStartupDate());
        adminApp().registerAdminPage(AdminGroups.INFO, new InfoAdminPage(appName, versionHolder(), startup));
    }
}
