package ru.yandex.calendar.admin;

import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

import ru.yandex.misc.spring.ApplicationContextUtils;
import ru.yandex.misc.spring.DelayShutdownListener;
import ru.yandex.misc.spring.ServiceStartListener;
import ru.yandex.misc.spring.ServiceUtils;

/**
 * Creates separate application context for modconsole to prevent unwanted admin functions
 * @author dbrylev
 */
public class CalendarModeratorContextStarter
        implements ServiceStartListener, DelayShutdownListener, ApplicationContextAware
{
    private ApplicationContext parentContext;
    private AnnotationConfigApplicationContext childContext;

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.parentContext = applicationContext;
    }

    @Override
    public void start() {
        childContext = new AnnotationConfigApplicationContext();
        childContext.setParent(parentContext);
        childContext.register(CalendarModeratorContextConfiguration.class);

        // dbrylev: PropertyPlaceHolderConfigurer does not work in child context
        Object configurer = parentContext.getAutowireCapableBeanFactory().getBean("propertyPlaceholderConfigurer");
        ApplicationContextUtils.registerSingleton(childContext, "propertyPlaceholderConfigurer", configurer);

        childContext.refresh();
        ServiceUtils.startAllServices(childContext);
    }

    @Override
    public void stop() {
        ServiceUtils.stopAllServices(childContext);
        childContext.stop();
    }
}
