package ru.yandex.calendar.admin;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.misc.db.masterSlave.dynamic.DynamicMasterSlaveDataSource;
import ru.yandex.misc.web.servlet.PingConfigurableServlet;

/**
 * @author dbrylev
 */
public class CalendarPingServlet extends PingConfigurableServlet {
    @Autowired
    private DynamicMasterSlaveDataSource dataSource;

    @Override
    protected boolean checkCustomCondition() {
        return dataSource.isFirstCheckCompleted()
                && dataSource.getDataSourcesWithStatuses("").exists(ds -> ds.isAvailable().orElse(false))
                && super.checkCustomCondition();
    }
}
