package ru.yandex.calendar.admin;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.calendar.frontend.mulca.Mulcagate;
import ru.yandex.calendar.frontend.ywmi.Ywmi;
import ru.yandex.calendar.logic.user.UserManager;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.email.Email;

/**
 * @author dbrylev
 */
public class MailAdminManager {

    @Autowired
    private Ywmi ywmi;
    @Autowired
    private Mulcagate mulcagate;
    @Autowired
    private UserManager userManager;


    public ListF<String> downloadByMessageId(Email email, String messageId) {
        return downloadByMessageId(getUid(email), messageId);
    }

    public ListF<String> downloadByMessageId(PassportUid uid, String messageId) {
        return ywmi.filterSearch(uid, ywmi.messagesByMessageId(uid, messageId).mids)
                .envelopes.map(e -> mulcagate.getMail(e.stid));
    }

    public String downloadByMid(Email email, long mid) {
        return downloadByMid(getUid(email), mid);
    }

    public String downloadByMid(PassportUid uid, long mid) {
        return mulcagate.getMail(ywmi.filterSearch(uid, mid).stid);
    }

    private PassportUid getUid(Email email) {
        return userManager.getUserOrMaillistByEmail(email).getOrThrow("User not found ", email).uid;
    }
}
