<xsl:stylesheet
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:math="http://exslt.org/math"
        exclude-result-prefixes="xsl math"
        version="1.0">

    <xsl:import href="admin://common.xsl"/>

    <xsl:template match="page" mode="head-extra-x"/>
    <xsl:template match="page" mode="content-centered"/>
    <xsl:template match="page" mode="additional-script"/>

    <xsl:template match="page" mode="head-extra">
        <style type="text/css">
            h3, h4, h5 { margin: 10px; }
            table { font-size: 13px; }
            input[type="button"], input[type="text"], input[type="submit"], select, button { margin: 0 2px; }
            form .required:after { color: #e32; content: '*'; display:inline; padding-left: 10px; }
            .radio, .checkbox { min-height: 18px; padding-left: 20px; }
            .tabbable>.nav { margin-bottom: 18px; }
            .tabs-left>.nav-tabs { float: left; margin-right: 19px; }
            .tab-content { overflow: auto; }
        </style>
        <xsl:apply-templates select="." mode="head-extra-x"/>
    </xsl:template>

    <xsl:template match="page" mode="content">
        <div id="content" class="container">
            <xsl:apply-templates select="." mode="content-centered"/>
        </div>
    </xsl:template>

    <xsl:template match="*" mode="as-table">
        <xsl:call-template name="table-for-list">
            <xsl:with-param name="list">
                <xsl:copy-of select="."/>
            </xsl:with-param>
        </xsl:call-template>
    </xsl:template>

    <xsl:template match="*" mode="as-table-for-list">
        <div style="overflow-x: auto;">
            <xsl:call-template name="table-for-list">
                <xsl:with-param name="list">
                    <xsl:copy-of select="*"/>
                </xsl:with-param>
            </xsl:call-template>
        </div>
    </xsl:template>

    <xsl:template match="*" mode="table-cell-value">
        <xsl:choose>
            <xsl:when test="@uid">
                <a href="/z/user/?q={@uid}"><xsl:value-of select="."/></a>
            </xsl:when>
            <xsl:when test="@resource-id">
                <a href="/z/rooms/edit?id={@resource-id}"><xsl:value-of select="."/></a>
            </xsl:when>
            <xsl:when test="@exchange-id">
                <a href="/z/exchange/item?tab=id-lookup&amp;id={@exchange-id}"><xsl:value-of select="."/></a>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="."/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="tabbed-top">
        <xsl:param name="titles"/>
        <xsl:param name="tabs"/>

        <xsl:call-template name="tabbed">
            <xsl:with-param name="tabs" select="$tabs"/>
            <xsl:with-param name="titles" select="$titles"/>
            <xsl:with-param name="orientation">top</xsl:with-param>
        </xsl:call-template>
    </xsl:template>

    <xsl:template name="tabbed-left">
        <xsl:param name="titles"/>
        <xsl:param name="tabs"/>

        <xsl:call-template name="tabbed">
            <xsl:with-param name="tabs" select="$tabs"/>
            <xsl:with-param name="titles" select="$titles"/>
            <xsl:with-param name="orientation">left</xsl:with-param>
        </xsl:call-template>
    </xsl:template>

    <xsl:template name="table-for-list">
        <xsl:param name="list"/>
        <xsl:variable name="elements" select="$list/*"/>

        <table class="table table-condensed table-striped">
            <colgroup>
                <col class="span3"/>
            </colgroup>
            <tbody>
                <xsl:for-each select="$elements[1]/*">
                    <tr>
                        <th><xsl:value-of select="name()"/></th>
                        <xsl:variable name="fieldNum" select="position()"/>
                        <xsl:for-each select="$elements/*[$fieldNum]">
                            <td>
                                <xsl:apply-templates select="." mode="table-cell-value"/>
                            </td>
                        </xsl:for-each>
                    </tr>
                </xsl:for-each>
            </tbody>
        </table>
    </xsl:template>

    <xsl:template name="tabbed">
        <xsl:param name="tabs"/>
        <xsl:param name="titles"/>
        <xsl:param name="orientation"/>

        <xsl:variable name="tabs-id" select="concat('tab-', format-number(math:random() * 6666666, '##0'), '-')"/>
        <xsl:variable name="active-position" select="count($titles/*[@active]/preceding-sibling::*) + 1"/>

        <div class="{concat('tabbable tabs-', $orientation)}">
            <ul class="nav nav-tabs {substring('nav-stacked', 1, number($orientation = 'left') * 11)}">
                <xsl:for-each select="$titles/*">
                    <xsl:variable name="class" select="substring('active', 1, number(position() = $active-position) * 10)"/>
                    <li class="{$class}">
                        <a data-toggle="tab" href="{concat('#', $tabs-id, position())}">
                            <xsl:copy-of select="."/>
                        </a>
                    </li>
                </xsl:for-each>
            </ul>
            <div class="tab-content">
                <xsl:for-each select="$tabs/*">
                    <xsl:variable name="active-class" select="substring('active', 1, number(position() = $active-position) * 10)"/>
                    <div id="{concat($tabs-id, position())}" class="{concat('tab-pane ', $active-class)}">
                        <xsl:copy-of select="."/>
                    </div>
                </xsl:for-each>
            </div>
        </div>
    </xsl:template>

</xsl:stylesheet>
