<?xml version="1.0"?>

<xsl:stylesheet
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:xs="http://www.w3.org/2001/XMLSchema"
        exclude-result-prefixes="xsl"
        version="2.0">

    <xsl:import href="./../common/common.xsl"/>

    <xsl:template match="page" mode="content-centered">
        <xsl:apply-templates select="assigned-room-list"/>
    </xsl:template>

    <xsl:template match="assigned-room-list">
        <table class="table table-striped">
            <colgroup>
                <col class="span4"/>
                <col class="span2"/>
            </colgroup>
            <tbody>
                <tr>
                    <th>Name</th>
                    <th>Office</th>
                    <th>Inactive</th>
                    <th>AutoDecline</th>
                    <th>Last ping</th>
                    <th>Actions</th>
                </tr>
                <xsl:for-each select="room">
                    <tr>
                        <td><xsl:value-of select="name"/></td>
                        <td><xsl:value-of select="office-name"/></td>
                        <td><xsl:if test="active = 'false'"><i class="icon-remove"/></xsl:if></td>
                        <td>
                            <xsl:if test="auto-decline = 'true'">
                                <i class="icon-ok"/>
                                <xsl:text>&#160;</xsl:text>
                                <a href="/z/displays/autodecline?id={id}&amp;off=true">Turn off</a>
                            </xsl:if>
                            <xsl:if test="auto-decline != 'true'">
                                <a href="/z/displays/autodecline?id={id}&amp;off=false">Turn on</a>
                            </xsl:if>
                        </td>
                        <td>
                            <xsl:if test="last-ping">
                                <xsl:variable name="last-ping-date" select="xs:date(xs:dateTime(last-ping))"/>
                                <xsl:variable name="days" select="days-from-duration(current-date() - $last-ping-date)"/>

                                <xsl:if test="0 >= $days">
                                    <xsl:value-of select="format-dateTime(last-ping, '[H01]:[m]')"/>
                                </xsl:if>
                                <xsl:if test="$days = 1">
                                    <xsl:value-of select="format-dateTime(last-ping, '[Y]-[M01]-[D01] [H01]:[m]')"/>
                                </xsl:if>
                                <xsl:if test="$days > 1">
                                    <xsl:value-of select="format-dateTime(last-ping, '[Y]-[M01]-[D01]')"/>
                                </xsl:if>
                            </xsl:if>
                            <xsl:if test="broken = 'true'">
                                <span class="badge-lonely label label-danger">Broken</span>
                            </xsl:if>
                        </td>
                        <td><a href="/z/displays/unassign?id={id}">Unassign</a></td>
                    </tr>
                </xsl:for-each>
            </tbody>

        </table>
    </xsl:template>

</xsl:stylesheet>
