package ru.yandex.calendar.admin.event;

import javax.annotation.PostConstruct;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.calendar.admin.BeanXmlizerForAdmin;
import ru.yandex.calendar.logic.event.EventDbManager;
import ru.yandex.calendar.logic.event.repetition.RepetitionRoutines;
import ru.yandex.calendar.logic.notification.NotificationDbManager;
import ru.yandex.commune.admin.web.AdminApp;

/**
 * @author Stepan Koltsov
 */
@Configuration
public class EventAdminContextConfiguration {

    @Autowired
    private AdminApp adminApp;
    @Autowired
    private EventDbManager eventDbManager;
    @Autowired
    private RepetitionRoutines repetitionRoutines;
    @Autowired
    private BeanXmlizerForAdmin beanXmlizerForAdmin;
    @Autowired
    private NotificationDbManager notificationDbManager;

    @Bean
    public EventAdminManager eventAdminManager() {
        return new EventAdminManager();
    }

    @PostConstruct
    public void configure() {
        adminApp.registerAdminPage(new EventAdminPage(eventAdminManager(), eventDbManager, repetitionRoutines,
                beanXmlizerForAdmin, notificationDbManager));
    }
} //~
