package ru.yandex.calendar.admin.event;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple3;
import ru.yandex.calendar.logic.beans.generated.Event;
import ru.yandex.calendar.logic.beans.generated.EventUser;
import ru.yandex.calendar.logic.beans.generated.MainEvent;
import ru.yandex.calendar.logic.beans.generated.MainEventFields;
import ru.yandex.calendar.logic.event.ExternalId;
import ru.yandex.calendar.logic.event.dao.EventDao;
import ru.yandex.calendar.logic.event.dao.EventUserDao;
import ru.yandex.calendar.logic.event.dao.MainEventDao;
import ru.yandex.misc.lang.StringUtils;

/**
 * @author Stepan Koltsov
 */
public class EventAdminManager {

    @Autowired
    private EventDao eventDao;
    @Autowired
    private MainEventDao mainEventDao;
    @Autowired
    private EventUserDao eventUserDao;

    public ListF<Long> findMainEventIdsByAny(String q) {
        if (StringUtils.isEmpty(q)) {
            return Cf.list();
        }

        ListF<Long> mainEventIds = Cf.arrayList();

        Option<Long> eventId = Cf.Long.parseSafe(q);
        if (eventId.isPresent()) {
            try {
                mainEventIds.add(eventDao.findEventById(eventId.get()).getMainEventId());
            } catch (EmptyResultDataAccessException e) {
                //
            }
        }

        mainEventIds.addAll(mainEventDao.findMainEventsByExternalId(new ExternalId(q)).map(MainEventFields.ID.getF()));

        Option<Tuple3<EventUser, Event, MainEvent>> o = eventUserDao.findEventUserAndJunkByExchangeId(q);
        if (o.isPresent()) {
            mainEventIds.add(o.get()._3.getId());
        }

        return mainEventIds.unique().sorted();
    }

} //~
