<?xml version="1.0"?>

<xsl:stylesheet
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:date="http://exslt.org/dates-and-times"
        exclude-result-prefixes="xsl date"
        version="1.0">

    <xsl:import href="./../common/common.xsl"/>

    <xsl:variable name="q" select="/page/req/query/param[@name='q']/@value"/>

    <xsl:template match="page" mode="content-centered">
        <form method="GET" class="well">
            <input type="text" name="q" value="{$q}" class="input-xlarge" placeholder="Event id, external id, exchange id..."/>
            <button class="btn">I'm Feeling Lucky</button>
        </form>
        <xsl:apply-templates select="main-events"/>
    </xsl:template>

    <xsl:template match="main-event-with-children">
        <h3>Main event</h3>
        <xsl:apply-templates select="main-event" mode="as-table"/>

        <h3>Events</h3>
        <xsl:call-template name="tabbed-top">
            <xsl:with-param name="titles"><xsl:apply-templates select="events" mode="title"/></xsl:with-param>
            <xsl:with-param name="tabs"><xsl:apply-templates select="events"/></xsl:with-param>
        </xsl:call-template>
    </xsl:template>

    <xsl:template match="event-with-children" mode="title">
        <span>
            <xsl:if test="event/id = $q"><xsl:attribute name="active"/></xsl:if>
            <xsl:choose>
                <xsl:when test="date:date(event/recurrence-id)">
                    Recurrence <xsl:value-of select="date:date(event/recurrence-id)"/>
                </xsl:when>
                <xsl:otherwise>Master event</xsl:otherwise>
            </xsl:choose>
        </span>
    </xsl:template>

    <xsl:template match="event-with-children">
        <div>
            <xsl:apply-templates select="event" mode="as-table"/>
            <xsl:apply-templates select="repetition-with-children"/>

            <h4>Event users, resources and invitations</h4>
            <xsl:call-template name="tabbed-left">
                <xsl:with-param name="titles">
                    <xsl:apply-templates select="event-users" mode="title"/>
                    <xsl:apply-templates select="event-resources" mode="title"/>
                    <xsl:apply-templates select="invitations" mode="title"/>
                </xsl:with-param>
                <xsl:with-param name="tabs">
                    <xsl:apply-templates select="event-users"/>
                    <xsl:apply-templates select="event-resources"/>
                    <xsl:apply-templates select="invitations"/>
                </xsl:with-param>
            </xsl:call-template>

            <h4>Event layers</h4>
            <xsl:call-template name="tabbed-left">
                <xsl:with-param name="titles">
                    <xsl:apply-templates select="event-layers" mode="title"/>
                </xsl:with-param>
                <xsl:with-param name="tabs">
                    <xsl:apply-templates select="event-layers"/>
                </xsl:with-param>
            </xsl:call-template>
        </div>
    </xsl:template>

    <xsl:template match="repetition-with-children">
        <xsl:apply-templates select="repetition"/>
        <xsl:apply-templates select="rdates"/>
        <xsl:apply-templates select="exdates"/>
    </xsl:template>

    <xsl:template match="repetition">
        <h4>Repetition</h4>
        <xsl:apply-templates select="." mode="as-table"/>
    </xsl:template>

    <xsl:template match="rdates">
        <xsl:if test="count(*) > 0">
            <h5>R-dates</h5>
            <xsl:apply-templates select="." mode="as-table-for-list"/>
        </xsl:if>
    </xsl:template>

    <xsl:template match="exdates">
        <xsl:if test="count(*) > 0">
            <h5>Ex-dates</h5>
            <xsl:apply-templates select="." mode="as-table-for-list"/>
        </xsl:if>
    </xsl:template>

    <xsl:template match="event-user-with-children" mode="title">
        <xsl:apply-templates select="event-user/uid" mode="user-title"/>
    </xsl:template>

    <xsl:template match="event-user-with-children">
        <div>
            <xsl:apply-templates select="event-user" mode="as-table"/>
            <xsl:if test="count(notifications/*) > 0">
                <h5>Notifications</h5>
                <xsl:apply-templates select="notifications" mode="as-table-for-list"/>
            </xsl:if>
        </div>
    </xsl:template>

    <xsl:template match="event-resource-with-children" mode="title">
        <xsl:apply-templates select="event-resource/resource-id" mode="resource-title"/>
    </xsl:template>

    <xsl:template match="event-resource-with-children">
        <xsl:apply-templates select="event-resource" mode="as-table"/>
    </xsl:template>

    <xsl:template match="invitation-with-children" mode="title">
        <span><xsl:value-of select="event-invitation/email"/></span>
    </xsl:template>

    <xsl:template match="invitation-with-children">
        <xsl:apply-templates select="event-invitation" mode="as-table"/>
    </xsl:template>

    <xsl:template match="event-layer-with-children" mode="title">
        <xsl:apply-templates select="event-layer/l-creator-uid" mode="user-title"/>
    </xsl:template>

    <xsl:template match="event-layer-with-children">
        <xsl:apply-templates select="event-layer" mode="as-table"/>
    </xsl:template>

    <xsl:template match="resource-id" mode="resource-title">
        <xsl:choose>
            <xsl:when test="string-length(@name) > 0">
                <span><xsl:value-of select="@name"/></span>
            </xsl:when>
            <xsl:when test="string-length(@exchange-name) > 0">
                <span><xsl:value-of select="@exchange-name"/></span>
            </xsl:when>
            <xsl:otherwise>
                <span><xsl:value-of select="@email"/></span>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="uid|l-creator-uid" mode="user-title">
        <xsl:choose>
            <xsl:when test="@login">
                <span><xsl:value-of select="@login"/></span>
            </xsl:when>
            <xsl:otherwise>
                <span><xsl:value-of select="@uid"/></span>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

</xsl:stylesheet>
