package ru.yandex.calendar.admin.event;

import org.dom4j.Element;

import ru.yandex.bolts.collection.Either;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.admin.BeanXmlizerForAdmin;
import ru.yandex.calendar.logic.beans.generated.Event;
import ru.yandex.calendar.logic.beans.generated.EventInvitation;
import ru.yandex.calendar.logic.beans.generated.EventLayer;
import ru.yandex.calendar.logic.beans.generated.EventNotification;
import ru.yandex.calendar.logic.beans.generated.EventResource;
import ru.yandex.calendar.logic.beans.generated.Rdate;
import ru.yandex.calendar.logic.event.EventDbManager;
import ru.yandex.calendar.logic.event.EventUserWithRelations;
import ru.yandex.calendar.logic.event.EventWithRelations;
import ru.yandex.calendar.logic.event.MainEventWithRelations;
import ru.yandex.calendar.logic.event.repetition.RepetitionInstanceInfo;
import ru.yandex.calendar.logic.event.repetition.RepetitionRoutines;
import ru.yandex.calendar.logic.notification.EventNotifications;
import ru.yandex.calendar.logic.notification.NotificationDbManager;
import ru.yandex.calendar.logic.resource.ResourceInfo;
import ru.yandex.commune.a3.action.ActionContainer;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.commune.admin.z.ZAction;
import ru.yandex.misc.xml.dom4j.Dom4jUtils;

/**
 * @author Stepan Koltsov
 */
@ActionContainer
public class EventAdminPage {

    private final EventAdminManager eventAdminManager;
    private final EventDbManager eventDbManager;
    private final RepetitionRoutines repetitionRoutines;
    private final BeanXmlizerForAdmin beanXmlizerForAdmin;
    private final NotificationDbManager notificationDbManager;

    public EventAdminPage(EventAdminManager eventAdminManager, EventDbManager eventDbManager,
            RepetitionRoutines repetitionRoutines, BeanXmlizerForAdmin beanXmlizerForAdmin,
            NotificationDbManager notificationDbManager)
    {
        this.eventAdminManager = eventAdminManager;
        this.eventDbManager = eventDbManager;
        this.repetitionRoutines = repetitionRoutines;
        this.beanXmlizerForAdmin = beanXmlizerForAdmin;
        this.notificationDbManager = notificationDbManager;
    }

    @ZAction(defaultAction = true)
    @Path("/event")
    public Element index(
            @RequestParam("q")
            Option<String> queryO)
    {
        String q = queryO.getOrElse("");

        Element mainEventsElement = Dom4jUtils.createElement("main-events");
        for (long mainEventId : eventAdminManager.findMainEventIdsByAny(q)) {
            Element mainEventElement = mainEventsElement.addElement("main-event-with-children");
            MainEventWithRelations mainEventWithRelations = eventDbManager.getMainEventWithRelationsById(mainEventId);
            mainEventElement.add(beanXmlizerForAdmin.xmlize(mainEventWithRelations.getMainEvent()));

            ListF<Long> eventUserIds = mainEventWithRelations.getEventsWithRelations()
                    .flatMap(e -> e.getEventUsersWithRelation().map(eu -> eu.getEventUser().getId()));

            MapF<Long, EventNotifications> notificationsByEventUserId = notificationDbManager
                    .getNotificationsByEventUserIds(eventUserIds)
                    .toMapMappingToKey(EventNotifications::getEventUserId);

            MapF<Long, RepetitionInstanceInfo> repetitionInfoByEventId = repetitionRoutines
                    .getRepetitionInstanceInfos(mainEventWithRelations.getEventsWithRelations());

            Element eventsElement = mainEventElement.addElement("events");
            for (EventWithRelations eventWithRelations : mainEventWithRelations.getEventsWithRelations()) {
                Event event = eventWithRelations.getEvent();
                Element eventElement = eventsElement.addElement("event-with-children");
                eventElement.add(beanXmlizerForAdmin.xmlize(event));

                RepetitionInstanceInfo repetitionInfo = repetitionInfoByEventId.getOrThrow(event.getId());
                if (!repetitionInfo.isEmpty()) {
                    Element repetitionElement = eventElement.addElement("repetition-with-children");

                    if (repetitionInfo.getRepetition().isPresent()) {
                        repetitionElement.add(beanXmlizerForAdmin.xmlize(repetitionInfo.getRepetition().get()));
                    }

                    Element rdatesElement = repetitionElement.addElement("rdates");
                    for (Rdate rdate : repetitionInfo.getRdates()) {
                        rdatesElement.add(beanXmlizerForAdmin.xmlize(rdate));
                    }
                    Element exdatesElement = repetitionElement.addElement("exdates");
                    for (Rdate exdate : repetitionInfo.getExdates()) {
                        exdatesElement.add(beanXmlizerForAdmin.xmlize(exdate));
                    }
                }

                Element eventUsersElement = eventElement.addElement("event-users");
                for (EventUserWithRelations eventUser : eventWithRelations.getEventUsersWithRelation()) {
                    Element eventUserElement = eventUsersElement.addElement("event-user-with-children");
                    eventUserElement.add(beanXmlizerForAdmin.xmlize(eventUser.getEventUser(),
                            Option.of(Either.left(eventUser.getSettings()))));

                    EventNotifications eventNotifications = notificationsByEventUserId
                            .getOrThrow(eventUser.getEventUser().getId());

                    Element notificationsElement = eventUserElement.addElement("notifications");
                    for (EventNotification notification : eventNotifications.getEventNotifications()) {
                        notificationsElement.add(beanXmlizerForAdmin.xmlize(notification));
                    }
                }

                Element invitationsElement = eventElement.addElement("invitations");
                for (EventInvitation invitation : eventWithRelations.getInvitations()) {
                    Element invitationElement = invitationsElement.addElement("invitation-with-children");
                    invitationElement.add(beanXmlizerForAdmin.xmlize(invitation));
                }

                Element eventLayersElement = eventElement.addElement("event-layers");
                for (EventLayer eventLayer : eventWithRelations.getEventLayers()) {
                    Element eventLayerElement = eventLayersElement.addElement("event-layer-with-children");
                    eventLayerElement.add(beanXmlizerForAdmin.xmlize(eventLayer));
                }

                MapF<Long, ResourceInfo> resourceById = eventWithRelations.getResources()
                        .toMapMappingToKey(ResourceInfo::getResourceId);

                Element eventResourcesElement = eventElement.addElement("event-resources");
                for (EventResource eventResource : eventWithRelations.getEventResources()) {
                    Element eventResourceElement = eventResourcesElement.addElement("event-resource-with-children");
                    eventResourceElement.add(beanXmlizerForAdmin.xmlize(eventResource,
                            Option.of(Either.right(resourceById.getOrThrow(eventResource.getResourceId())))));
                }
            }
        }

        // XXX: lookup in deleted

        return mainEventsElement;
    }

} //~
