package ru.yandex.calendar.admin.exchange;

import javax.annotation.PostConstruct;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.calendar.boot.EwsAliveHandler;
import ru.yandex.calendar.frontend.ews.ExchangeEmailManager;
import ru.yandex.commune.admin.web.AdminApp;
import ru.yandex.commune.util.serialize.ToMultilineSerializer;


/**
 * @author ssytnik
 */
@Configuration
public class ExchangeAdminContextConfiguration {

    @Autowired
    private AdminApp adminApp;
    @Autowired
    private ExchangeEmailManager exchangeEmailManager;
    @Autowired
    private ToMultilineSerializer toMultilineSerializer;
    @Autowired
    private EwsAliveHandler ewsAliveHandler;

    @Bean
    public ExchangeAdminManager exchangeAdminManager() {
        return new ExchangeAdminManager();
    }

    @PostConstruct
    public void configure() {
        adminApp.registerAdminPage(new ExchangeAdminPage(exchangeAdminManager(), exchangeEmailManager, toMultilineSerializer, ewsAliveHandler));
    }
}
