<?xml version="1.0"?>

<xsl:stylesheet
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        exclude-result-prefixes="xsl"
        version="1.0">

    <xsl:import href="./../common/common.xsl"/>

    <xsl:variable name="id" select="/page/req/query/param[@name='id']/@value"/>
    <xsl:variable name="parent-by-occurrence-id" select="/page/req/query/param[@name='parent-by-occurrence-id']/@value"/>
    <xsl:variable name="detailed-view" select="/page/req/query/param[@name='detailed-view']/@value"/>

    <xsl:variable name="start-date" select="/page/req/query/param[@name='start-date']/@value"/>
    <xsl:variable name="end-date" select="/page/req/query/param[@name='end-date']/@value"/>
    <xsl:variable name="item-type" select="/page/req/query/param[@name='item-type']/@value"/>
    <xsl:variable name="email" select="/page/req/query/param[@name='email']/@value"/>

    <xsl:variable name="misc-compare-days" select="/page/req/query/param[@name='misc-compare-days']/@value"/>
    <xsl:variable name="misc-all-resources" select="/page/req/query/param[@name='misc-all-resources']/@value"/>
    <xsl:variable name="misc-offset" select="/page/req/query/param[@name='misc-offset']/@value"/>
    <xsl:variable name="misc-limit" select="/page/req/query/param[@name='misc-limit']/@value"/>
    <xsl:variable name="misc-with-dues" select="/page/req/query/param[@name='misc-with-dues']/@value"/>
    <xsl:variable name="misc-exchange-id" select="/page/req/query/param[@name='misc-exchange-id']/@value"/>

    <xsl:variable name="tab" select="/page/req/query/param[@name='tab']/@value"/>

    <xsl:template match="page" mode="content">
        <div id="content" class="container">
            <xsl:call-template name="tabbed-top">
                <xsl:with-param name="titles">
                    <span><xsl:if test="$tab = 'id-lookup'"><xsl:attribute name="active"/></xsl:if>Item id lookup</span>
                    <span><xsl:if test="$tab = 'interval-lookup'"><xsl:attribute name="active"/></xsl:if>Interval lookup</span>
                    <span><xsl:if test="$tab = 'monitor-sync'"><xsl:attribute name="active"/></xsl:if>Monitor synchronization</span>
                    <span><xsl:if test="$tab = 'events-fix'"><xsl:attribute name="active"/></xsl:if>Fix events</span>
                </xsl:with-param>
                <xsl:with-param name="tabs">
                    <xsl:call-template name="id-lookup-tab"/>
                    <xsl:call-template name="interval-lookup-tab"/>
                    <xsl:call-template name="monitor-sync-tab"/>
                    <xsl:call-template name="events-fix-tab"/>
                </xsl:with-param>
            </xsl:call-template>
        </div>
        <xsl:if test="$tab">
            <pre><xsl:value-of select="output"/></pre>
        </xsl:if>
    </xsl:template>

    <xsl:template name="id-lookup-tab">
        <form method="GET" action="/z/exchange/item" class="form-horizontal">
            <input type="hidden" name="tab" value="id-lookup"/>

            <fieldset>
                <div class="control-group">
                    <label class="control-label">Search parameters</label>
                    <div class="controls">
                        <input type="text" name="id" value="{$id}"
                            class="input-xxlarge" placeholder="Exchange item id"/>
                    </div>
                    <div class="controls">
                        <label class="checkbox">
                            <input type="checkbox" name="parent-by-occurrence-id" value="1">
                                <xsl:if test="$parent-by-occurrence-id = '1'">
                                    <xsl:attribute name="checked"/>
                                </xsl:if>
                            </input>
                            <xsl:text>Parent by occurrence id</xsl:text>
                        </label>
                        <label class="checkbox">
                            <input type="checkbox" name="detailed-view" value="1">
                                <xsl:if test="$detailed-view = '1'">
                                    <xsl:attribute name="checked"/>
                                </xsl:if>
                            </input>
                            <xsl:text>Show details</xsl:text>
                        </label>
                    </div>
                </div>
                <div class="controls">
                    <button class="btn">Get item</button>
                </div>
            </fieldset>
        </form>
    </xsl:template>

    <xsl:template name="interval-lookup-tab">
        <form method="GET" action="/z/exchange/interval" class="form-horizontal ">
            <input type="hidden" name="tab" value="interval-lookup"/>

            <fieldset>
                <div class="control-group">
                    <label class="control-label">Search interval</label>
                    <div class="controls">
                        <xsl:variable name="today-click">
                            var d = new Date();
                            var value = [d.getFullYear(), d.getMonth() + 1, d.getDate()].join('-');
                            $(this).parent().find('[name=start-date]').val(value);
                        </xsl:variable>
                        <input type="button" value="Today »" onClick="{$today-click}" class="btn"/>
                        <input type="text" name="start-date" value="{$start-date}"
                               class="input-small" placeholder="Start date"/>

                        <xsl:variable name="copy-click">
                            var p = $(this).parent();
                            p.find('[name=end-date]').val(p.find('[name=start-date]').val())
                        </xsl:variable>
                        <input type="button" value="»" onClick="{$copy-click}" class="btn"/>
                        <input type="text" name="end-date" value="{$end-date}"
                               class="input-small" placeholder="End date"/>
                    </div>
                    <div class="controls">
                        <label class="radio">
                            <input type="radio" name="item-type" value="masters">
                                <xsl:if test="$item-type = 'masters'">
                                    <xsl:attribute name="checked"/>
                                </xsl:if>
                                <xsl:text>Masters and singles starting in interval</xsl:text>
                            </input>
                        </label>
                        <label class="radio">
                            <input type="radio" name="item-type" value="instances">
                                <xsl:if test="not($item-type) or $item-type = '' or $item-type = 'instances'">
                                    <xsl:attribute name="checked"/>
                                </xsl:if>
                                <xsl:text>All occurrences overlapping interval</xsl:text>
                            </input>
                        </label>
                    </div>
                </div>
                <div class="control-group">
                    <label class="control-label">Mailbox</label>
                    <div class="controls"><xsl:call-template name="email-field"/></div>
                </div>
                <div class="controls">
                    <button class="btn">Find items</button>
                </div>
            </fieldset>
        </form>
    </xsl:template>

    <xsl:template name="monitor-sync-tab">
        <form method="GET" action="/z/exchange/misc" class="form-horizontal">
            <input type="hidden" name="tab" value="monitor-sync"/>

            <fieldset>
                <div class="control-group">
                    <label class="control-label">Mailbox</label>
                    <div class="controls"><xsl:call-template name="email-field"/></div>
                </div>
                <div class="control-group">
                    <label class="control-label">Compare for</label>
                    <div class="controls">
                        <input type="text" name="misc-compare-days" value="{$misc-compare-days}"
                               maxlength="2" class="span1" placeholder="3"/>
                        <span>days</span>
                    </div>
                </div>
                <div class="controls">
                    <input type="submit" name="compare" value="Compare" class="btn"/>
                    <input type="submit" name="top-copies" value="Find top copies" class="btn"/>
                    <input type="submit" name="check-subscribed" value="Check subscription" class="btn"/>
                    <input type="submit" name="compare-ews" value="Compare all ews-synced accounts" class="btn"/>
                </div>
            </fieldset>
            <br/>
            <fieldset class="well">
                <input type="submit" name="compare-random" value="Compare random subject" class="btn"/>
            </fieldset>
        </form>
    </xsl:template>

    <xsl:template name="events-fix-tab">
        <div>
        <form method="GET" action="/z/exchange/misc" class="form-horizontal">
            <input type="hidden" name="tab" value="events-fix"/>

            <fieldset>
                <div class="control-group">
                    <label class="control-label">Lookup source</label>
                    <div class="controls">
                        <div class="span4">
                            <label class="radio">
                                <input type="radio" name="misc-all-resources" value="0">
                                    <xsl:if test="not($misc-all-resources) or $misc-all-resources = 0">
                                        <xsl:attribute name="checked"/>
                                    </xsl:if>
                                </input>
                                <xsl:text>Mailbox</xsl:text>
                            </label>
                            <xsl:call-template name="email-field"/>
                        </div>
                        <div>
                            <label class="radio">
                                <input type="radio" name="misc-all-resources" value="1">
                                    <xsl:if test="$misc-all-resources = 1">
                                        <xsl:attribute name="checked"/>
                                    </xsl:if>
                                </input>
                                <xsl:text>All resources </xsl:text>
                            </label>
                            <span>Limit</span>
                            <input type="text" name="misc-limit" value="{$misc-limit}" maxlength="3" class="span1"/>
                            <span>offset</span>
                            <input type="text" name="misc-offset" value="{$misc-offset}" maxlength="3" class="span1"/>
                        </div>
                    </div>
                </div>
                <div class="control-group">
                    <div class="controls">
                        <label class="checkbox">
                            <input type="checkbox" name="misc-with-dues" value="1">
                                <xsl:if test="$misc-with-dues = '1'">
                                    <xsl:attribute name="checked"/>
                                </xsl:if>
                            </input>
                            <xsl:text>Show with DUEs</xsl:text>
                        </label>
                    </div>
                </div>
                <div class="controls">
                    <input type="submit" name="filter-utc-masters" value="Filter UTC masters" class="btn"/>
                    <input type="submit" name="filter-all-days" value="Filter all-days" class="btn"/>
                </div>
            </fieldset>
        </form>
        <hr/>
        <form method="GET" action="/z/exchange/misc" class="form-horizontal">
            <input type="hidden" name="tab" value="events-fix"/>
            <fieldset>
                <div class="control-group">
                    <label class="control-label">Fix target</label>
                    <div class="controls">
                        <div class="span4">
                            <label class="radio">
                                <input type="radio" name="fix-target" checked="1"/>
                                <xsl:text>Mailbox</xsl:text>
                            </label>
                            <xsl:call-template name="email-field"/>
                        </div>
                        <div>
                            <label class="radio">
                                <input type="radio" name="fix-target"/>
                                <xsl:text>Item id</xsl:text>
                            </label>
                            <input type="text" name="id" value="{$misc-exchange-id}"
                                   class="input-xlarge" placeholder="Exchange item id"/>
                        </div>
                    </div>
                </div>
                <div class="controls">
                    <input type="submit" name="fix-utc-masters" value="Fix UTC masters in exchange" class="btn"/>
                    <input type="submit" name="fix-all-days" value="Fix all-days in calendar" class="btn"/>
                </div>
            </fieldset>
        </form>
        </div>
    </xsl:template>

    <xsl:template name="email-field">
        <xsl:variable name="add-on">@yandex-team.ru</xsl:variable>

        <xsl:variable name="change">
            var value = $(this).val().split('@')[0];
            var p = $(this).parent();
            p.find('[type=hidden]').val(value.length > 0 ? value + p.find('.add-on').html() : '');
            $(this).val(value);
        </xsl:variable>

        <div class="input-append inline">
            <input type="hidden" name="email" value="{$email}"/>
            <input type="text" value="{substring-before($email, '@')}" onChange="{$change}" class="span2"/>
            <span class="add-on"><xsl:value-of select="$add-on"/></span>
        </div>
    </xsl:template>

</xsl:stylesheet>

<!-- vim: set encoding=utf-8 ts=4 sw=4 et: -->
