package ru.yandex.calendar.admin.exchange;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.email.Email;

/**
 * @author ssytnik
 */
public abstract class ExchangeEventsLookup {

    private ExchangeEventsLookup() { }


    public abstract static class ExchangeEventsLookupByEmails extends ExchangeEventsLookup {

        private ExchangeEventsLookupByEmails() { }

    }


    public static class LookupByExchangeEmail extends ExchangeEventsLookupByEmails {
        Email exchangeEmail;

        private LookupByExchangeEmail(Email exchangeEmail) {
            this.exchangeEmail = exchangeEmail;
        }

        public Email getExchangeEmail() {
            return exchangeEmail;
        }
    }


    public static class LookupInSubscribedResources extends ExchangeEventsLookupByEmails {
        Option<Integer> offsetO;
        Option<Integer> limitO;

        private LookupInSubscribedResources(Option<Integer> offsetO, Option<Integer> limitO) {
            this.offsetO = offsetO;
            this.limitO = limitO;
        }

        public Option<Integer> getOffsetO() {
            return offsetO;
        }

        public Option<Integer> getLimitO() {
            return limitO;
        }
    }


    public static class LookupByExchangeId extends ExchangeEventsLookup {
        String exchangeId;

        private LookupByExchangeId(String exchangeId) {
            this.exchangeId = exchangeId;
        }

        public String getExchangeId() {
            return exchangeId;
        }
    }


    public static LookupByExchangeEmail lookupByExchangeEmail(Email exchangeEmail) {
        return new LookupByExchangeEmail(exchangeEmail);
    }

    public static LookupInSubscribedResources lookupInSubscribedResources(Option<Integer> offsetO, Option<Integer> limitO) {
        return new LookupInSubscribedResources(offsetO, limitO);
    }

    public static LookupByExchangeId lookupByExchangeId(String exchangeId) {
        return new LookupByExchangeId(exchangeId);
    }
}
