package ru.yandex.calendar.admin.export;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.misc.web.servlet.HttpServletRequestX;

/**
 * @author dbrylev
 */
public class ExportServlet extends HttpServlet {

    @Autowired
    private ExportManager exportManager;

    @Override
    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        HttpServletRequestX reqX = HttpServletRequestX.wrap(req);
        String pathInfo = reqX.getPathInfoO().getOrElse("");

        if (pathInfo.equals("/previous-day-resource-conflicts")) {
            int count = exportManager.getResourceConflictsCountCreatedLastDay();
            resp.getOutputStream().write(Integer.toString(count).getBytes());
        }
    }
}
