<?xml version="1.0"?>

<!DOCTYPE xsl:stylesheet [
        <!ENTITY quot   "&#34;">
        <!ENTITY nbsp   "&#160;">
        ]>

<xsl:stylesheet
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        exclude-result-prefixes="xsl"
        version="1.0">

    <xsl:import href="classpath:ru/yandex/calendar/admin/common/common.xsl"/>

    <xsl:template match="page" mode="content-centered">
        <xsl:apply-templates select="view | create | edit"/>
    </xsl:template>

    <xsl:template match="view">
        <form method="GET">
            <input type="hidden" name="id" value=""/>

            <script type="text/javascript">
            //<![CDATA[
                var f = document.forms[0];
                function doAction(action, id) {
                    f.action = '/z/rooms/' + action;
                    f.id.value = id;
                    f.submit();
                }
                function createResource() {
                    doAction('create', '');
                }
                function editResource(id) {
                    doAction('edit', id);
                }
                function deleteResource(id) {
                    if (confirm('Delete id = ' + id + '?')) {
                        doAction('delete_do', id);
                    }
                }
            //]]>
            </script>

            <xsl:apply-templates/>
        </form>
    </xsl:template>

    <xsl:template match="resources-list">
        <div class="control-group"><a href="javascript:createResource();">Create new resource</a></div>
        <table class="table table-striped">
            <colgroup>
                <col class="span1"/>
                <col class="span6"/>
                <col class="span1"/>
            </colgroup>
            <tbody>
                <xsl:for-each select="resource">
                    <tr>
                        <td>
                            <xsl:if test="@is-active = 'false'">
                                <span class="label label-warning">Inactive</span>
                            </xsl:if>
                        </td>
                        <td>
                            <xsl:value-of select="@name"/>
                            (id = <xsl:value-of select="@id"/>)
                            <font color="gray"><xsl:value-of select="@exchange-name"/></font>
                        </td>
                        <td><a href="javascript:editResource({@id});">Edit</a></td>
                        <td><a href="javascript:deleteResource({@id});">Delete</a></td>
                    </tr>
                </xsl:for-each>
            </tbody>
        </table>
    </xsl:template>



    <xsl:template match="create">
        <h3>Create resource</h3>
        <xsl:call-template name="show-form"/>
    </xsl:template>

    <xsl:template match="edit">
        <h3>
            Edit resource
            &quot;<xsl:value-of select="resource/name"/>&quot;
            (id = <xsl:value-of select="resource/id"/>)
        </h3>
        <xsl:call-template name="show-form"/>
    </xsl:template>

    <xsl:template name="show-form">
        <form action="/z/rooms/{name()}_do" method="GET"> <!-- easy error recovery -->
            <fieldset class="span well">
                <table>
                    <xsl:for-each select="resource/*">
                        <tr>
                            <td>
                                <label>
                                    <xsl:if test="@required = 'true'">
                                        <xsl:attribute name="class">required</xsl:attribute>
                                    </xsl:if>
                                    <xsl:value-of select="name()"/>
                                </label>
                            </td>
                            <td><input type="text" name="{name()}" value="{.}" placeholder="{@type}"/></td>
                         </tr>
                    </xsl:for-each>
                    <tr>
                        <td/>
                        <td>
                            <br/>
                            <button class="btn btn-primary input-small">Save</button>
                            <button type="button" onClick="javascript:document.location='/z/rooms';" class="btn">Cancel</button>
                        </td>
                    </tr>
                </table>
            </fieldset>
        </form>
    </xsl:template>
</xsl:stylesheet>

<!-- vim: set encoding=utf-8 ts=4 sw=4 et: -->
