package ru.yandex.calendar.admin.resources;

import javax.annotation.PostConstruct;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.commune.admin.web.AdminApp;
import ru.yandex.commune.util.universal.UniversalObjectParser;

/**
 * @author ssytnik
 */
@Configuration
public class ResourcesContextConfiguration {

    @Autowired
    private AdminApp adminApp;
    @Autowired
    private UniversalObjectParser universalObjectParser;

    @Bean
    public ResourcesManager resourcesManager() {
        return new ResourcesManager();
    }

    @PostConstruct
    public void configure() {
        adminApp.registerAdminPage(new ResourcesAdminPage(resourcesManager(), universalObjectParser));
    }
}
